% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlwin2bugs.R
\name{mlwin2bugs}
\alias{mlwin2bugs}
\title{This function captures output files from MLwiN for estimation in
WinBUGS/OpenBUGS.}
\usage{
mlwin2bugs(
  D,
  levID,
  datafile,
  initfiles,
  modelfile,
  bugEst,
  fact,
  addmore,
  n.chains,
  n.iter,
  n.burnin,
  n.thin,
  debug = FALSE,
  bugs.directory = bugs.directory,
  bugsWorkingDir = tempdir(),
  OpenBugs = FALSE,
  cleanBugsWorkingDir = FALSE,
  seed = NULL
)
}
\arguments{
\item{D}{A vector specifying the type of distribution used in the model.}

\item{levID}{A character (vector) specifying the level ID(s).}

\item{datafile}{A file name where the BUGS data file will be saved in
.txt format.}

\item{initfiles}{A list of file names where the BUGS initial values will
be saved in .txt format.}

\item{modelfile}{A file name where the BUGS model will be saved in .txt
format.}

\item{bugEst}{A file name where the estimates from BUGS will be stored in
.txt format.}

\item{fact}{A list of objects used to specify factor analysis. See `Details'
below.}

\item{addmore}{A vector of strings specifying additional coefficients to be
monitored.}

\item{n.chains}{The number of chains to be monitored.}

\item{n.iter}{The number of iterations for each chain}

\item{n.burnin}{The length of burn-in for each chain}

\item{n.thin}{Thinning rate}

\item{debug}{A logical value indicating whether (\code{TRUE}) or not
(\code{FALSE}; the default) to close the BUGS window after completion of the
model run}

\item{bugs.directory}{The full path of location where WinBUGS is installed 
(ignored if OpenBugs is \code{TRUE}).}

\item{bugsWorkingDir}{A directory where all the intermediate files are to be
stored; defaults to \code{tempdir()}.}

\item{OpenBugs}{If \code{TRUE}, OpenBUGS is used, if \code{FALSE} (the
default) WinBUGS is used.}

\item{cleanBugsWorkingDir}{If \code{TRUE}, the generated files will be
removed from the \code{bugsWorkingDir}; defaults to \code{FALSE}.}

\item{seed}{An integer specifying the random seed.}
}
\value{
Returns an \code{\link[coda]{mcmc}} object.
}
\description{
This function allows R to call WinBUGS using the output files from MLwiN.
This function uses functionalities in the \code{\link[R2WinBUGS]{R2WinBUGS-package}}
package.
}
\details{
A list of objects to specify factor analysis, as used in the
argument \code{fact}:
\itemize{
\item \code{nfact}: specifies the number of factors;
\item \code{lev.fact}: Specifies the level/classification for the random part of
the factor for each factor;
\item \code{nfactcor}: specifies the number of
correlated factors;
\item \code{factcor}: a vector specifying the correlated
factors: the first element corresponds to the first factor number, the
second to the second factor number, the third element corresponds to the
starting value for the covariance and the fourth element to whether this
covariance is constrained
(\code{1}) or not (\code{0}). If more than one pair of factors is correlated,
then repeat this sequence for each pair.
\item \code{loading}: a matrix specifying the
starting values for the factor loadings and the starting value of the factor
variance. Each row corresponds to a factor.
\item \code{constr}: a matrix
specifying indicators of whether the factor loadings and the factor variance
are constrained (\code{1}) or not (\code{0}).
}
}
\seealso{
\code{\link{runMLwiN}},\code{\link[R2WinBUGS]{bugs}}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
