% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{polarProjection,PathwaySpace-method}
\alias{polarProjection,PathwaySpace-method}
\alias{polarProjection}
\title{Creating 2D-landscape images from graph objects.}
\usage{
\S4method{polarProjection}{PathwaySpace}(
  pts,
  kns = 8,
  pdist = 0.5,
  rescale = TRUE,
  theta = 180,
  directional = FALSE,
  verbose = TRUE,
  decay_fun = weibullDecay,
  knn = deprecated(),
  ...
)
}
\arguments{
\item{pts}{A \linkS4class{PathwaySpace} class object.}

\item{kns}{A single positive integer determining the k-nearest signal 
sources used in the signal convolution operation.}

\item{pdist}{A term (in \code{[0,1]}) determining a distance unit for the
signal convolution related to length between any two connected vertices. 
This distance will affect the extent over which the convolution operation 
projects the signal between source- and destination points along the 
polar coordinates of the edges. The signal projection tends to zero at
`pdist`, and when `pdist = 1` the projection will extend to its maximum 
distance, defined by the length between the two connected vertices.}

\item{rescale}{A single logical value indicating whether to rescale 
the signal. If the signal \code{>=0}, then it will be rescaled to 
\code{[0,1]}; if the signal \code{<=0}, then it will be rescaled to 
\code{[-1,0]}; and if the signal in \code{(-Inf,+Inf)}, then it will be 
rescaled to \code{[-1,1]}.}

\item{theta}{Angle of projection (degrees in \code{(0,360]}).}

\item{directional}{If directional edges are available, this argument can 
be used to orientate the signal projection on directed graphs.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}

\item{decay_fun}{A signal decay function. Available: 'Weibull', 
'exponential', and 'linear' functions (see \code{\link{weibullDecay}}).}

\item{knn}{Deprecated from PathwaySpace 1.0; use `kns` instead.}

\item{...}{Additional arguments passed to the decay function.}
}
\value{
A preprocessed \linkS4class{PathwaySpace} class object.
}
\description{
\code{polarProjection} implements a convolution algorithm
to project a signal across a 2D-coordinate system.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'PathwaySpace')

# Create a new PathwaySpace object
pts <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

# Create a 2D-landscape image
pts <- polarProjection(pts)

}
\seealso{
\code{\link{buildPathwaySpace}}
}
\author{
Vinicius Chagas, Victor Apolonio, Mauro Castro,
and TCGA Network.
}
