% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preanalysis_functions.r
\name{runClassical}
\alias{runClassical}
\title{Run CTT-based reliability analysis}
\usage{
runClassical(data, omega = FALSE, scalewise = TRUE, ...)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{omega}{if \code{TRUE}, also obtain McDonald's omega using \code{\link[psych]{omega}} in \href{https://CRAN.R-project.org/package=psych}{\code{psych}} package. (default = \code{FALSE})}

\item{scalewise}{if \code{TRUE}, run analysis for each instrument as well as for the combined instrument. If \code{FALSE}, run analysis only for the combined instrument. (default = \code{TRUE})}

\item{...}{additional arguments to pass onto \code{\link[psych]{omega}}.}
}
\value{
\code{\link{runClassical}} returns a \code{\link{list}} containing reliability analysis results.
}
\description{
\code{\link{runClassical}} is a function for performing a Classical Test Theory (CTT) based reliability analysis.
}
\examples{
out_alpha <- runClassical(data_asq)
out_omega <- runClassical(data_asq, omega = TRUE) # also obtain omega

}
