% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMMeanAtTime}
\alias{PCMMeanAtTime}
\title{Calculate the mean at time t, given X0, under a PCM model}
\usage{
PCMMeanAtTime(
  t,
  model,
  X0 = model$X0,
  regime = PCMRegimes(model)[1L],
  verbose = FALSE
)
}
\arguments{
\item{t}{positive numeric denoting time}

\item{model}{a PCM model object}

\item{X0}{a numeric vector of length k, where k is the number of traits in the model (Defaults to model$X0).}

\item{regime}{an integer or a character denoting the regime in model for
which to do the calculation; Defaults to PCMRegimes(model)[1L], meaning the
first regime in the model.}

\item{verbose}{a logical indicating if (debug) messages should be written on the console (Defaults to FALSE).}
}
\value{
A numeric vector of length k
}
\description{
Calculate the mean at time t, given X0, under a PCM model
}
\examples{
# a Brownian motion model with one regime
modelBM <- PCM(model = "BM", k = 2)
# print the model
modelBM
# assign the model parameters at random: this will use uniform distribution
# with boundaries specified by PCMParamLowerLimit and PCMParamUpperLimit
# We do this in two steps:
# 1. First we generate a random vector. Note the length of the vector equals PCMParamCount(modelBM)
randomParams <- PCMParamRandomVecParams(modelBM, PCMNumTraits(modelBM), PCMNumRegimes(modelBM))
randomParams
# 2. Then we load this random vector into the model.
PCMParamLoadOrStore(modelBM, randomParams, 0, PCMNumTraits(modelBM), PCMNumRegimes(modelBM), TRUE)

# PCMMeanAtTime(1, modelBM)

# note that the variance at time 0 is not the 0 matrix because the model has a non-zero
# environmental deviation
PCMMeanAtTime(0, modelBM)
}
