% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.outliers.R
\name{detect.outliers}
\alias{detect.outliers}
\title{Detect outliers}
\usage{
detect.outliers(
  data,
  num.null = 1000,
  initial.screen.method = c("fdr", "p.value"),
  p.value.threshold = 0.05,
  fdr.threshold = 0.01,
  kmeans.nstart = 1
)
}
\arguments{
\item{data}{A matrix or data frame of normalized RNA-seq data, organized with transcripts on rows and samples on columns.  Transcript identifiers should be stored as \code{rownames(data)}.}

\item{num.null}{The number of transcripts to generate when simulating from null distributions; default is 1000. We recommend using at least 10,000 iterations for publication-level results, with 100,000 or even one million iterations providing more robust estimates.}

\item{initial.screen.method}{The statistical criterion for initial gene selection; valid options are 'FDR' and 'p-value'.}

\item{p.value.threshold}{The p-value threshold for the outlier test; default is 0.05.  Once the p-value for a sample exceeds \code{p.value.threshold}, testing for that transcript ceases, and all remaining samples will have p-values equal to \code{NA}.}

\item{fdr.threshold}{The false discovery rate (FDR)-adjusted p-value threshold for determining the final count of outliers; default is 0.01.}

\item{kmeans.nstart}{The number of random starts when computing k-means fraction; default is 1.  See \code{?stats::kmeans} for further details.}
}
\value{
A list consisting of the following entries:
\itemize{
\item \code{p.values}: a matrix of unadjusted p-values for the outlier test run on each transcript in \code{data}.
\item \code{fdr}: a matrix of FDR-adjusted p-values for the outlier test run on each transcript in \code{data}.
\item \code{num.outliers}: a vector giving the number of outliers detected for each transcript based on the threshold.
\item \code{outlier.test.results.list}: a list of length \code{max(num.outliers) + 1} containing entries \code{roundN}, where \code{N} is between one and \code{max(num.outliers) + 1}.  \code{roundN} is the data frame of results for the outlier test after excluding the (N-1)th outlier sample, with \code{round1} being for the original data set (i.e., before excluding any outlier samples).
\item \code{distributions}: a numeric vector indicating the optimal distribution for each transcript.  Possible values are 1 (normal), 2 (log-normal), 3 (exponential), and 4 (gamma).
\item \code{initial.screen.method}: Specifies the statistical criterion for initial feature selection. Valid options are 'p-value' and 'FDR' (p-value used by default).
}
}
\description{
Detect outliers in normalized RNA-seq data.
}
\examples{
data(outliers);
outliers.subset <- outliers[1:10,];
results <- detect.outliers(
   data = outliers.subset,
   num.null = 10
   );
}
