% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{lineplot_split_clone}
\alias{lineplot_split_clone}
\title{Show line plots of all integration sites over time, split into facets by
their respective clone.}
\usage{
lineplot_split_clone(
  bd,
  rec,
  order = NULL,
  mapping = NULL,
  sim = NULL,
  silhouette_values = !is.null(sim),
  singletons = TRUE,
  zero_values = TRUE
)
}
\arguments{
\item{bd}{The readouts of the integration sites over time.}

\item{rec}{A matrix with columns "IS" and "Clone", that describes for each
integration site, which clone it belongs to.}

\item{order}{Integration site names will be converted to a factor. This
allows to give the order for this factor, as it influences the
order in which the lines are drawn.}

\item{mapping}{A ggplot2 aesthetics mapping that will be merged with the
aesthetics used by this plot.}

\item{sim}{A similarity matrix giving the similarities for each pair of
integration sites. Used if `silhouette_values` is `TRUE` to
calculate the silhouette score.}

\item{silhouette_values}{A boolean value that determines whether the
silhouette values for each clone should be
calculated and added to the facet labels.
Requires `sim` to be present.}

\item{singletons}{Whether to show clones that only have a single integration
site.}

\item{zero_values}{How to handle values that are zero. If `TRUE`, they remain
zero and subsequently, a the measurement the line drops to
zero. If `FALSE`, the values are removed and a gap in the
line is shown.}
}
\description{
Show line plots of all integration sites over time, split into facets by
their respective clone.
}
