% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_DLmoments}
\alias{sim_DLmoments}
\title{Simulated moment-based test statistics}
\usage{
sim_DLmoments(Tsize, N)
}
\arguments{
\item{Tsize}{Length of sample size for simulation.}

\item{N}{Number of simulated samples.}
}
\value{
A (\code{N x 4}) matrix with \code{N} different simulated moment-based test statistics.
}
\description{
This function computes the four moment-based test statistics (eq. \code{11} - \code{14}) discussed in Dufour & Luger 2017 for \code{N} different simulated series.
}
\references{
Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
}
\keyword{internal}
