% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prepare_Graph_Input.R
\name{get_onset_time}
\alias{get_onset_time}
\title{Calculate age of diagnosis, age at end of follow up, and status}
\usage{
get_onset_time(
  tbl,
  start,
  end,
  event,
  status_col = "status",
  aod_col = "aod",
  age_eof_col = "age"
)
}
\arguments{
\item{tbl}{tibble with start, end, and event as columns}

\item{start}{start of follow up, typically birth date, must be a date column}

\item{end}{end of follow up, must be a date column}

\item{event}{event of interest, typically date of diagnosis, must be a date column}

\item{status_col}{column name of status column to be created. Defaults to "status".}

\item{aod_col}{column name of age of diagnosis column to be created. Defaults to "aod".}

\item{age_eof_col}{column name of age at end of follow-up column to be created. Defaults to "age_eof".}
}
\value{
tibble with added status, age of diagnosis, and age at end of follow-up
}
\description{
Calculate age of diagnosis, age at end of follow up, and status
}
\examples{
# See vignettes.
}
