% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{wgmmreg}
\alias{wgmmreg}
\title{wgmmreg}
\usage{
wgmmreg(
  X,
  Y,
  CX,
  CY,
  wx = NULL,
  wy = NULL,
  maxIter = 200,
  subsample = NULL,
  tol = 1e-08
)
}
\arguments{
\item{X}{reference point set, a N x D matrix}

\item{Y}{point set to transform, a M x D matrix,}

\item{CX}{array of covariance matrices for each point in X}

\item{CY}{array of covariance matrices for each point in Y}

\item{wx}{(optional) vector of mixture weights for X.}

\item{wy}{(optional) vector of mixture weights for Y.}

\item{maxIter}{maximum number of iterations to perform (default: 200)}

\item{subsample}{if set, use this randomly selected fraction of the points}

\item{tol}{tolerance for determining convergence (default: 1e-8)}
}
\value{
a list of 
 \itemize{
    \item Y: transformed point set, 
    \item R: rotation matrix, 
    \item t: translation vector,
    \item c: final value of the cost function,
    \item converged: logical, whether the algorithm converged.
 }
}
\description{
Rigid registration of two point sets by minimizing the Wasserstein distance between GMMs
}
\examples{
data.file1 <- system.file("test_data", "parasaurolophusA.txt", package = "LOMAR",
 mustWork = TRUE)
PS1 <- read.csv(data.file1, sep = '\t', header = FALSE)
data.file2 <- system.file("test_data", "parasaurolophusB.txt", package = "LOMAR",
 mustWork = TRUE)
C1 <- diag(0.1, ncol(PS1)) + jitter(0.01, amount = 0.01)
C1 <- replicate(nrow(PS1),C1)
PS2 <- read.csv(data.file2, sep = '\t', header = FALSE)
C2 <- diag(0.1, ncol(PS2)) + jitter(0.01, amount = 0.01)
C2 <- replicate(nrow(PS2),C2)
transformation <- wgmmreg(PS1, PS2, C1, C2, subsample = 0.1, maxIter = 30, tol = 1e-4)
\dontrun{
# Visualize registration outcome
library(rgl)
plot3d(PS1, col = "blue")
points3d(PS2, col = "green")
points3d(transformation[['Y']], col = "magenta")
}
}
