% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JATS_get.country.R
\name{get.country}
\alias{get.country}
\title{get.country}
\usage{
get.country(x, unifyCountry = TRUE)
}
\arguments{
\item{x}{a NISO-JATS coded XML file or text.}

\item{unifyCountry}{Logical. If TRUE replaces country name with standardised country name.}
}
\value{
Character vector with the extracted country name/s.
}
\description{
Extracts country tag from NISO-JATS coded XML file or text as vector of unique countries.
}
\examples{
x<-"Some text <country>UK</country> some text <country>England</country>
    Text<country>Berlin, Germany</country>"
get.country(x)
}
\seealso{
\code{\link[JATSdecoder]{JATSdecoder}} for simultaneous extraction of meta-tags, abstract, sectioned text and reference list.
}
