% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t.R
\name{iscamtprob}
\alias{iscamtprob}
\title{Tail Probability for t-distribution}
\usage{
iscamtprob(xval, df, direction, xval2 = NULL, verbose = TRUE)
}
\arguments{
\item{xval}{observed value.}

\item{df}{degrees of freedom.}

\item{direction}{direction for probability calculation, "above" or "below"; if
"outside" or "between" are used, a second larger observation, \code{xval2} must be
specified}

\item{xval2}{second observation value.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
The tail probability in the specified direction using the given
parameters.
}
\description{
Tail Probability for t-distribution
}
\examples{
iscamtprob(xval = -2.05, df = 10, direction = "below")
iscamtprob(xval = 1.80, df = 20, direction = "above")
iscamtprob(xval = -2, xval2 = 2, df = 15, direction = "between")
iscamtprob(xval = -2.5, xval2 = 2.5, df = 25, direction = "outside")
}
