% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ICS_lcov}
\alias{ICS_lcov}
\title{Local Shape Scatter Estimates for ICS}
\usage{
ICS_lcov(x, mscatter = "cov", proportion = 0.1, ...)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{mscatter}{\code{"mcd"} or \code{"cov"} (default); specified minimum covariance
determinant or classical covariance matrix to be used for Mahalanobis
distance computation.}

\item{proportion}{proportion of points to be considered as neighbourhood.}

\item{...}{potential further arguments passed to \code{\link[fpc:localshape]{fpc::localshape()}}.}
}
\value{
An object of class \code{"ICS_scatter"} with the following
components:
\item{location}{this is NULL as the estimator does not use a
location estimate.}
\item{scatter}{a numeric matrix giving the estimate of the scatter matrix.}
\item{label}{a character string providing a label for the scatter matrix.}
}
\description{
It is a wrapper for the local shape estimator of scatter
as computed by \code{\link[fpc:localshape]{fpc::localshape()}}.
}
\seealso{
\code{\link[fpc:localshape]{fpc::localshape()}}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
