% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_logistic_4par}
\alias{FIM_logistic_4par}
\title{Fisher Information Matrix for the 4-Parameter Logistic Model}
\usage{
FIM_logistic_4par(x, w, param)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \code{c(theta1, theta2, theta3, theta4)}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for the FIM for the model
 \code{~theta1/(1+exp(theta2*x+theta3))+theta4}.
 This model is another re-parameterization of the 4-parameter Hill model.
  For more details, see Eq. (1) and (2) in Hyun and  Wong (2015).
}
\details{
The fisher information matrix does not depend on \code{theta4}.\cr
}
\examples{
FIM_logistic_4par(x = c(-6.9, -4.6, -3.9, 6.7 ),
                  w = c(0.489, 0.40, 0.061, 0.050),
                  param = c(1.563, 1.790, 8.442, 0.137))
}
\references{
Hyun, S. W., & Wong, W. K. (2015). Multiple-Objective Optimal Designs for Studying the Dose Response Function and Interesting Dose Levels. The international journal of biostatistics, 11(2), 253-271.
}
\seealso{
\code{\link{multiple}}
}
