% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_ave.R
\name{ave}
\alias{ave}
\title{Imperialist Competitive Algorithm to find optimum on-the-average designs based on the least favorable distribution.}
\usage{
ave(fimfunc, lx, ux, prior, param, iter, k, control = list(),
  initial = NULL, ...)
}
\arguments{
\item{fimfunc}{the name of the FIM from available FIM functions in the package as a character string or the user-written function that returns the FIM as a \code{matrix}. See "Details" in \link{mica}.}

\item{lx}{lower bound of the design space \eqn{\chi}}

\item{ux}{upper bound of the design space \eqn{\chi}}

\item{prior}{a vector of the probability measure \eqn{\pi}.}

\item{param}{a matrix for set of parameters, i.e. support of \eqn{\pi}. Every row is is a vector of values of a parameter.
The number of its rows must be equal to the length of \code{prior}.}

\item{iter}{maximum number of iterations}

\item{k}{number of design (support) points. Must be larger than the number of model parameters \eqn{p} to avoid singularity of the FIM.}

\item{control}{a list of contains the tuning parameters of ICA and the design problem. See "Details" of \code{\link{mica}}.}

\item{initial}{a matrix of the  initial designs that will be used as initial countries in ICA.
Every row is a design and concatenation of \code{x} and \code{w}.  Default is \code{NULL}. See "Details" of \code{\link{mica}}.}

\item{...}{further arguments to be passed to the FIM function given by \code{fimfunc}.}
}
\value{
an object of class "ICA". See "Value" in \code{\link{mica}}.
}
\description{
For nonlinear models, if a set of possible values of the vector parameters \eqn{\bold{\theta}} is available, the optimum-on-the-average designs
can be applied. In this approach the criterion is evaluated at plausible parameter values and weighted by a probability measure
\eqn{\pi}, the measure having support in the parameter space \eqn{\Theta}. The resulted weighted criterion is thus
\deqn{B(\xi, \pi) = \int_{\Theta}\Psi(\xi, \theta)d(\pi(\theta)).}{B(\xi, \Pi) = \int_{\Theta}\Psi(\xi, \theta)d(\pi(\theta)).}
For current version \eqn{\Psi(\xi, \theta)} is equal to \eqn{|M(\xi, \theta)|}.
}
\examples{
\dontrun{
test <- ave(fimfunc = "FIM_logistic",
                       lx = -5, ux = 5, prior = rep(1/4, 4),
                       param = matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2),
                       iter = 200, k = 3)

plot(test)
print(test)
################################################################################
## using equivalence theorem as stopping rule. Can be applied in H-algorithm
test <- ave (fimfunc = "FIM_logistic",
                         lx = -5, ux = 5, prior = rep(1/4, 4),
                         param = matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2),
                         iter = 200, k =3,
                         control = list(stop_rule = "equivalence",
                         stoptol = .9995, equivalence_every = 100))
}

}

