% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_equivalence.R
\name{equivalence}
\alias{equivalence}
\title{Checking minimax, standardized maximin and locally D-optimality of a givne design by equivalence theorem}
\usage{
equivalence(fimfunc, x, w, lx, ux, lp, up, type, n.seg = 6,
  maxeval_equivalence = 6000, locally = NULL, control_gosolnp = NULL,
  plot_3d = "lattice", plot_sensitivity = TRUE, ...)
}
\arguments{
\item{fimfunc}{Fisher information matrix. Can be the name of the Fisher information matrix from FIM family functions available in this package as a
character string or a function that returns the information matrix. See "Details" of \code{\link{mica}}.}

\item{x}{a vector of design points. When design space is multi-dimensional then \code{x} should be filled dimension by dimension. See "Examples".}

\item{w}{a vector of design weights.}

\item{lx}{lower bound of the design space \eqn{\chi}.}

\item{ux}{upper bound of the design space \eqn{\chi}.}

\item{lp}{lower bound of the region of unceratinty \eqn{\Theta}. The order of the dimension is the same as the order of the parameters in the argument \code{param}of \code{fimfunc}.}

\item{up}{upper bound of the region of unceratinty \eqn{\Theta}. If \code{lp = up}, then \eqn{\Theta = \boldsymbol{\theta_0} = lp}{\Theta = \theta_0 = lp} and the design is checked for locally D-optimality, See also argument \code{type}.}

\item{type}{a character strings; \code{'minimax'} for minimax optimal design, \code{'standardized'} for standardized maximin D-optimal design and \code{'locally'} for locally D-optimal design.}

\item{n.seg}{the number of starting points for finding all local optima to construct the answering set is \code{(n.seg + 1)^p}. Only for minimax and standardized maximin optimal designs. See "Details".}

\item{maxeval_equivalence}{maximum number of evaulations (\code{maxeval})  that will be passed to optimization function \code{\link[nloptr]{directL}} to find the maximum of the sensitivity function required for calculating DLB. See "Details".}

\item{locally}{a function that returns the value of determinant of FIM for
the locally D-optimal design, i.e.  \eqn{|M(\xi_{\boldsymbol{\theta}}, \boldsymbol{\theta})|}{|M(\xi_\theta, \theta)|}.
 Only required when \code{type} is set to \code{"standardized"}. See "Details"}

\item{control_gosolnp}{tuning parameters of function \code{\link[Rsolnp]{gosolnp}} for models that their locally optimal design do not have an
analytical solution and is find by \code{\link[Rsolnp]{gosolnp}}. Only required when \code{type} is set to \code{'standardized'}. See "Details".}

\item{plot_3d}{a character strings to show which packages should be used for plotting the sensitivity function when
design space is of two dimension; \code{"lattice"} to use package \link[lattice]{lattice} and \code{"rgl"} to use package \link[rgl]{rgl}.
The package should be installed before use.}

\item{plot_sensitivity}{logical; sensitivity should be plotted? see "Details".}

\item{...}{further argument to be passed to \code{fimfunc}.}
}
\value{
an object of class \code{'equivalence'} that is a list contains:
 \describe{
 \item{\code{type}}{argumet \code{type} required for print methods.}
 \item{\code{all_optima}}{a matrix; all optima of the inner problem (optimization over the parameter space for the given design to find the minimum efficiency for standardized maximin design or maximum inefficiency for minimax. \code{NA} for locally optimal design.}
 \item{\code{all_optima_cost}}{cost of each element of \code{all_optima}. \code{NA} for locally optimal design.}
 \item{\code{answering}}{a matrix; answering set chosen from \code{all_optima}. \code{NA} for locally optimal design.}
 \item{\code{answering_cost}}{cost of each element of answering set. \code{NA} for locally optimal design.}
 \item{\code{mu}}{probability measure on answering set. Equal to \eqn{1} for locally D-optimal design.}
 \item{\code{max_deriv}}{maximum of the sensitivity function}
 \item{\code{DLB}}{D-efficiency lower bound. If negative, the value of \code{maxeval_equivalence} should be increased to find the global maximum.}
 \item{\code{crtval}}{criterion value. See "Details".}
 }
}
\description{
An approximate design \eqn{\xi} is a probability measure defined on a user-selected design space \eqn{\chi}.
Let \eqn{\Xi} be the space of all such designs on \eqn{\chi} and let \eqn{\xi}
 be an approximate design with \eqn{k} support points  at \eqn{\boldsymbol{x}_1, \boldsymbol{x}_2, ..., \boldsymbol{x}_k}{x1, x2, ..., xk}
  from \eqn{\chi} with corresponding weights  \eqn{w_1, . . . ,w_k}{w1, ..., wk},
  \eqn{\sum_{i=1}^{k} w_i = 1}{w1 + w2 + ...+ wk = 1}.
   A design \eqn{\xi^*}{\xi*} is minimax D-optimal among all designs on \eqn{\chi} if and only if there exists a probability measure \eqn{\mu^*}{\mu*} on
   \deqn{A(\xi^*) = \left\{\nu \in \Theta \mid -log|M(\xi^*, \nu)| = \max_{\theta \in \Theta} -log|M(\xi^*, \theta)| \right\},}{
     A(\xi*) = {\nu belongs to \Theta | -log|M(\xi*, \nu)| = maxization with respect to \theta over \Theta on function -log|M(\xi*, \theta)|} ,}
       such that the following inequality holds for all \eqn{\boldsymbol{x} \in \chi}{x belong to \chi}
        \deqn{c(\boldsymbol{x}, \mu^*, \xi^*) = \int_{A(\xi^*)} tr M^{-1}(\xi^*, \nu)I(\boldsymbol{x}, \nu)\mu^* d(\nu)-p \leq 0,}{
         c(x, \mu*, \xi*) = integration over A(\xi*) with integrand  tr M^-1(\xi*, \nu)I(x, \nu)\mu* d(\nu)-p <= 0,}
          with equality at all support points of \eqn{\xi^*}{\xi*}.
           Here, \eqn{p} is the number of model parameters. \eqn{c(\boldsymbol{x}, \mu^*, \xi^*)}{c(x, \mu*, \xi*)} is called \bold{sensitivity function}.
The set \eqn{A(\xi^*)}{A(\xi*)} is sometimes called the \bold{answering set} of
 \eqn{\xi^*}{\xi*} and the measure \eqn{\mu^*}{\mu*} is a subgradient of the
   non-differentiable criterion evaluated at \eqn{M(\xi^*,\nu)}{M(\xi*,\nu)}.\cr
}
\details{
For locally optimal designs the answering set has only one element that is \eqn{\nu = \boldsymbol{\theta_0} }{\nu = \theta_0} and \eqn{\mu =1}.
Thus, \code{n.seg} has no further use for locally optimal designs.\cr


    There is no theoretical rule on how to choose the number of points in \eqn{A(\xi^*)}{A(\xi*)} as support
 for the measure \eqn{\mu^*}{\mu*}  and they would have to be found by trial and error.
  To this end, we first find all the local maxima for optimization over \eqn{\Theta} by a local search (L-BFGS-B) with
   different \code{(n.seg + 1)^p} starting points  and then pick the ones nearest to the global minimum
    subject to a tolerance of \eqn{0.005}.\cr

 If \eqn{\chi} is one or two dimensional, one may plot sensitivity function \eqn{c(\boldsymbol{x}, \xi^*, \mu^*)}{c(x, \xi*, \mu*)} versus
  \eqn{\boldsymbol{x} \in \chi}{x (belongs to \chi)} and  visually inspect whether the graph meets the conditions in the equivalence theorem.
    If it does, the design \eqn{\xi^*}{\xi*} is minimax optimal; otherwise it is not optimal.


We measure the closeness of a design
 \eqn{\xi} to the minimax optimal design  using its minimax D-efficiency defined by
  \deqn{d_{\mbox{eff}} = \left(\frac{\max_{\boldsymbol{\theta} \in \Theta} -\log|M(\xi_D, \boldsymbol{\theta})|}{\max_{\boldsymbol{\theta} \in \Theta} -\log|M(\xi, \boldsymbol{\theta})|}\right)^{1/p},}{
    d_eff = {(maximum over \Theta -log|M(\xi_D, \theta)|)/(maximum over \Theta -log|M(\xi, \theta)|)}^(1/p),}
      where \eqn{\xi_D} is  the minimax D-optimal design.
Using argument similar to Atwood (1969), we obtain a D-efficiency Lower Bound (DLB) for the minimax D-efficiency of a design \eqn{\xi} without knowing \eqn{\xi^*}{\xi*}.
DLB is caluclated by \eqn{p/(p + max_{\boldsymbol{x} \in \chi}c(\boldsymbol{x}, \mu, \xi))}{p/(p + maximum over \chi c(x, \mu, \xi))}, where \eqn{\mu^*}{\mu*}
    is the probability measure defined on \eqn{A(\xi)} that maximizes \eqn{c(x_\xi,\mu,\xi)}{c(x_\xi,\mu,\xi)} over all probability measures \eqn{\mu}
     and \eqn{x_\xi}{x_\xi} is any arbitrary support point of \eqn{\xi}.\cr

 For standardazed maximin D-optimal design the answering set \eqn{N(\xi^*)}{N(\xi*)} is
   \deqn{N(\xi^*) = \left\{\boldsymbol{\nu} \in \Theta \mid \mbox{eff}_D(\xi^*, \boldsymbol{\nu}) = \min_{\boldsymbol{\theta} \in \Theta} \mbox{eff}_D(\xi^*, \boldsymbol{\theta}) \right\}.
     }{N(\xi*) = \{\nu belongs to \Theta  |eff_D(\xi*, \nu) = minimum over \Theta eff_D(\xi*, \theta) \},} where
     \eqn{\mbox{eff}_D(\xi, \boldsymbol{\theta}) =  (\frac{|M(\xi, \boldsymbol{\theta})|}{|M(\xi_{\boldsymbol{\theta}}, \boldsymbol{\theta})|})^\frac{1}{p}}{
     eff_D(\xi, \theta) =  (|M(\xi, \theta)|/|M(\xi_\theta, \theta)|)^(1/p)} and \eqn{\xi_\theta} is the locally D-optimal design with respect to \eqn{\theta}. \cr
 We measure the closeness of a design  \eqn{\xi} to the standardized maximin optimal design \eqn{\xi_D} using its standardized maximin  D-efficiency defined by
 \deqn{ d_{\mbox{eff}} = \frac{\min_{\boldsymbol{\theta} \in \Theta} \mbox{eff}_D(\xi, \boldsymbol{\theta})}{\min_{\boldsymbol{\theta} \in \Theta} \mbox{eff}_D(\xi_D, \boldsymbol{\theta})}.}{
 d_eff = (minimum over \Theta eff_D(\xi, \theta))/ (minimum over \Theta eff_D(\xi_D, \theta)).}
 Similar to the minimax design, we can also find standardized maximin D-efficiency
 lower bound for the generated standardized maximin design and locally D-optimal design.\cr

 For standardized maximin D-optimal designs the function \code{locally} is created automatically when \code{locally = NULL}:
  \itemize{
     \item{when \code{fimfunc} is a \bold{character} strings from the available FIM and
      locally D-optimal design has a \bold{closed-form} for the chosen model: }{
       \code{locally} is an algebraic function that returns the value of determinant of the FIM for
        the locally D-optimal design, i.e.
        \eqn{|M(\xi_{\boldsymbol{\theta}}, \boldsymbol{\theta})|}{|M(\xi_\theta, \theta)|}. See "Details"
        of each defined FIM for the formula.}
     \item{when \code{fimfunc} is a \bold{character} strings but locally D-optimal design has \bold{no closed-form}:}{
        \code{\link[Rsolnp]{gosolnp}} is used to find the locally D-optimal design
         (within the class of minimally-supported and equally-weighted designs). \code{control_gosolnp} is a list of
         some of the tunning parameters of \code{\link[Rsolnp]{gosolnp}} that are: \code{n.sim}
          (default \code{500}), \code{n.restarts} (default \code{1})
           and \code{trace} (default \code{FALSE}).}
     \item{when \code{fimfunc} is a \bold{user given} function:}{ same as the previous case.}
}
User can also provide its own \code{locally}. In this case, \code{args(locally)}
must be \code{function (param, auxiliary)}, where \code{param} is the vector of parameters and
\code{auxiliary} is an obligatory arguments for internal use when \code{locally = NULL}. Please see
"Examples" on how to use \code{locally}.\cr

For output \code{max_deriv}, if the local maximum is found (you can detect it from sensitivity plot) or DLB is negative,
 the value of \code{maxeval_equivalence} should be increased to return the global maximum.\cr

 The criterion value for locally D-optimal design is
 \deqn{-\log|M(\xi, \boldsymbol{\theta_0} )|;}{-log|M(\xi, \theta_0 )|;} for minimax optimal design is
 \deqn{\max_{\theta \in \Theta} -\log|M(\xi, \theta)|;}{max -log|M(\xi, \theta)|;}
 for standardized maximin optimal design is
 \deqn{\inf_{\theta \in \Theta} \left[\left(\frac{|M(\xi, \theta)|}{|M(\xi_{\theta}, \theta)|}\right)^\frac{1}{p}\right].}{
  inf {|M(\xi, \theta)| / |M(\xi_\theta, \theta)|}^p.}
}
\examples{
#############################################################
## check locally optimality: lp = up and type = "locally"
inipar <- c(2, 3)
equivalence (fimfunc = "FIM_logistic",
            x = c(1.485526, 2.51446 ),
            w = c(.5, .5),
            lx = -5, ux = 5,
            lp = inipar, up = inipar,
            type = "locally")

##############################################################################
## standardized maximin D-optimal design does not depend on theta0 and theta1,
##  so we fix them locally D-optimal design has a closed-form which is defined
##  internally
equivalence (fimfunc = "FIM_loglin",
            x = c(0, 4.2494, 17.0324, 149.9090),
            w = c(0.3204, 0.1207, 0.2293, 0.3296),
            lx = 0, ux = 150,
            lp = c(2, 2, 1), up = c(2, 2, 15),
            type = "standardized")

##############################################################################
\dontrun{
## there is no analytical solution for locally optimal design for this model
## gosolnp automatically will be used to find the locally
##  optimal design in the denominator of standardized criterion.
##  Becasue, it is two-level nested optimization
##  (first level on parameter space) and second level on design space)
##  it takes so long to find 'all_optima' and construct 'answerign' set.
equivalence (fimfunc = "FIM_power_logistic",
            x = c(-4.5515, 0.2130, 2.8075),
            w = c(0.4100, 0.3723, 0.2177),
            lx = -5, ux = 5,
            lp = c(0, 1), up = c(3, 1.5),
            type = "standardized",
            s = .2)
}


############################################################################
### when a design point is of two dimension
\dontrun{
equivalence (fimfunc = "FIM_mixed_inhibition",
            x = c(3.4614, 4.2801, 30, 30, 0, 3.1426, 0, 4.0373 ),
            w = rep(1/4, 4),
            lx = c(0, 0), ux = c(30, 60),
            lp = c(7, 4, 2, 4), up = c(7, 5, 3, 5),
            type = "standardized")
## here the design points are x1 = c(3.4614, 0), x2 = c(4.2801, 3.1426),
## x3 = c(30, 0), x4 = c(30, 4.0373)
## using package rgl (rgl must be installed for plot)
equivalence (fimfunc = "FIM_mixed_inhibition",
            x = c(3.4614, 4.2801, 30, 30, 0, 3.1426, 0, 4.0373 ),
            w = rep(1/4, 4),
            lx = c(0, 0), ux = c(30, 60),
            lp = c(7, 4, 2, 4), up = c(7, 5, 3, 5),
            type = "standardized", plot_3d = "rgl")

equivalence (fimfunc = "FIM_comp_inhibition",
            x = c(3.4432, 30, 30, 0, 0, 18.8954),
            w = rep(1/3, 3),
            lx = c(0, 0), ux = c(30, 60),
            lp = c(7, 4, 2), up = c(7, 5, 3),
            type = "standardized")
}
##########################################################################
##########################################################################
## defining function 'locally'
locally_det<- function(param,  auxiliary){
 ## param is the vector of theta = (theta0, theta1, theta2)
 ux <- 0
 lx <- 150
 xstar <- (ux + param[3]) * (lx + param[3]) * (log(ux + param[3]) -
  log(lx + param[3]))/(ux - lx) - param[3]
 denominator <- det(FIM_loglin(x = c(lx, xstar, ux) , w = rep(1/3, 3), param = param))
 return(denominator)
}
equivalence (fimfunc = "FIM_loglin",
            x = c(0, 4.2494, 17.0324, 149.9090),
            w = c(0.3204, 0.1207, 0.2293, 0.3296),
            lx = 0, ux = 150,
            lp = c(2, 2, 1), up = c(2, 2, 15),
            locally = locally_det,
            type = "standardized")
}
\references{
Atwood, C. L. (1969). Optimal and efficient designs of experiments. The Annals of Mathematical Statistics, 1570-1602.
}
\seealso{
\code{\link{print.equivalence}}, \code{\link{equivalence_on_average}} and \code{\link{equivalence_multiple}}.
}

