% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_estimates.R
\name{extract_estimates}
\alias{extract_estimates}
\title{Extract estimates for a given factor combination}
\usage{
extract_estimates(object, factors, subtract = FALSE, add_residuals = FALSE)
}
\arguments{
\item{object}{\code{asca} object.}

\item{factors}{\code{vector} of factor names or numbers.}

\item{subtract}{\code{logical} subtract the estimates from the data (default = FALSE).}

\item{add_residuals}{\code{logical} add residuals to the estimates (default = FALSE).}
}
\value{
A matrix of the extracted estimates.
}
\description{
Extracts and sums the LS estimates for a given factor combination
from an object of class \code{hdanova}. If \code{add_residuals} is \code{TRUE},
the residuals are added to the LS estimates. If \code{substract} is \code{TRUE},
the returned matrix is the data with chosen estimates subtracted.
}
\examples{
# Load candies data
data(candies)

# Basic HDANOVA model with two factors and interaction
mod <- hdanova(assessment ~ candy * assessor, data=candies)

# Extract estimates for the interaction
inter <- extract_estimates(mod, c("assessor:candy"))

# Visualize the interaction effect
image(t(inter), main="Interaction effect", xlab="Attribute", ylab="Sample")

}
