% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{estimate_k_max}
\alias{estimate_k_max}
\title{Estimate Maximum Neighbors for kd-Tree Thinning}
\usage{
estimate_k_max(coordinates, thin_dist, distance = c("haversine", "euclidean"))
}
\arguments{
\item{coordinates}{A matrix of spatial coordinates with two columns for longitude and latitude.}

\item{thin_dist}{A positive numeric value representing the thinning distance in kilometers.
This defines the resolution of the grid used for density calculations.}

\item{distance}{Distance metric used `c("haversine", "euclidean")`.}
}
\value{
A numeric value representing the maximum k (number of nearest neighbors) required
        for the densest regions in the dataset.
}
\description{
This function estimates the maximum value of k (the number of nearest neighbors)
for kd-tree-based thinning by evaluating the densest regions of a spatial dataset.
The function uses a histogram-based binning approach for efficiency and low memory usage.
}
\details{
The function divides the spatial domain into grid cells based on the specified thinning distance.
Grid cell sizes are determined assuming approximately 111.32 km per degree (latitude/longitude).
The function identifies the densest grid cells and their immediate neighbors to compute the maximum k value.
}
\examples{
# Generate sample data
set.seed(123)
coordinates <- matrix(runif(200, min = -10, max = 10), ncol = 2)

# Estimate k for kd-tree thinning
k_max <- estimate_k_max(coordinates, thin_dist = 50)
print(k_max)

}
