% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EunomiaData.R
\name{downloadEunomiaData}
\alias{downloadEunomiaData}
\title{Download Eunomia data files}
\usage{
downloadEunomiaData(
  datasetName,
  cdmVersion = "5.3",
  pathToData = Sys.getenv("EUNOMIA_DATA_FOLDER"),
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{datasetName}{The data set name as found on https://github.com/OHDSI/EunomiaDatasets. The
data set name corresponds to the folder with the data set ZIP files}

\item{cdmVersion}{The OMOP CDM version. This version will appear in the suffix of the data file,
for example: <datasetName>_<cdmVersion>.zip. Default: '5.3'}

\item{pathToData}{The path where the Eunomia data is stored on the file system., By default the
value of the environment variable "EUNOMIA_DATA_FOLDER" is used.}

\item{overwrite}{Control whether the existing archive file will be overwritten should it already
exist.}

\item{verbose}{Provide additional logging details during execution.}
}
\value{
Invisibly returns the destination if the download was successful.
}
\description{
Download the Eunomia data files from https://github.com/OHDSI/EunomiaDatasets
}
\examples{
\dontrun{
downloadEunomiaData("GiBleed")
}
}
