% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.HazardShape.R
\encoding{UTF-8}
\name{print.HazardShape}
\alias{print.HazardShape}
\title{Print method for \code{HazardShape} objects}
\usage{
\method{print}{HazardShape}(x, ...)
}
\arguments{
\item{x}{an object of class \code{HazardShape}, generated with
\code{\link{TTT_hazard_shape}}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Displays the estimated hazard shape given a \code{HazardShape} object.
}
\examples{
#--------------------------------------------------------------------------------
# Example 1: Increasing hazard and its corresponding TTT plot with simulated data

hweibull <- function(x, shape, scale){
  dweibull(x, shape, scale)/pweibull(x, shape, scale, lower.tail = FALSE)
  }
curve(hweibull(x, shape = 2.5, scale = pi), from = 0, to = 42,
               col = "red", ylab = "Hazard function", las = 1, lwd = 2)

y <- rweibull(n = 50, shape = 2.5, scale = pi)
my_initial_guess <- TTT_hazard_shape(formula = y ~ 1)
print(my_initial_guess)


#--------------------------------------------------------------------------------

}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
