% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risco.R
\name{risk}
\alias{risk}
\title{Risk of Disease Occurrence in Soybeans}
\usage{
risk(DAY, MONTH, AAT, RH, disease = "rust", verbose = FALSE, plot = FALSE)
}
\arguments{
\item{DAY}{The column for the day of the month.}

\item{MONTH}{The column for the month of the year (numeric value).}

\item{AAT}{The average air temperature column (in degree Celsius).}

\item{RH}{The relative humidity column (in \%).}

\item{disease}{Define the soybean disease (Standard = 'rust').}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Plot a graph of the accumulation (Default is F (FALSE)).}
}
\value{
Returns the parameters of the incidence probability of the selected
disease in the soybean crop, being: \cr
\cr
* RHrisk\cr
  Risk caused by relative humidity.\cr
\cr
* TEMPrisk\cr
  Risk caused by air temperature.\cr
\cr
* TOTALrisk\cr
  Product of the multiplication between RHrisk and TEMPrisk.\cr
\cr
* RELrisk\cr
  Relative risk obtained from the highest value of TOTALrisk.
}
\description{
Calculation of the Risk of Disease Occurrence in Soybeans as a Function of
Variables meteorological variables (Engers et al., 2024).
}
\examples{
library(EstimateBreed)

# Rust Risk Prediction
data("clima")
with(clima, risk(DY, MO, TMED, RH, disease = "rust"))
}
\references{
de Oliveira Engers, L.B., Radons, S.Z., Henck, A.U. et al.
Evaluation of a forecasting system to facilitate decision-making for the
chemical control of Asina soybean rust. Trop. plant pathol. 49, 539-546 (2024).
\doi{10.1007/s40858-024-00649-1}
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
