% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_reports_valid}
\alias{check_reports_valid}
\title{Validate data input}
\usage{
check_reports_valid(
  data,
  model = c("estimate_infections", "estimate_secondary")
)
}
\arguments{
\item{data}{A data frame with either:
\itemize{
\item a minimum of two columns: \code{date} and \code{confirm}, if to be
used by \code{\link[=estimate_infections]{estimate_infections()}} or \code{\link[=estimate_truncation]{estimate_truncation()}}, or
\item a minimum of three columns: \code{date}, \code{primary}, and \code{secondary}, if to be
used by \code{\link[=estimate_secondary]{estimate_secondary()}}.
}}

\item{model}{The EpiNow2 model to be used. Either
"estimate_infections", "estimate_truncation", or "estimate_secondary".
This is used to determine which checks to perform on the data input.}
}
\value{
Called for its side effects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\code{check_reports_valid()} checks that the supplied data is a \verb{<data.frame>},
and that it has the right column names and types. In particular, it checks
that the date column is in date format and does not contain NAs, and that
the other columns are numeric.
}
\keyword{internal}
