% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.FP.R
\name{FP}
\alias{FP}
\title{Computes the False Positive value.}
\description{
This is the number of individuals with a negative condition for
which the test result is positive. The value entered here must be non-negative.
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{FP}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FP-new}{\code{FP$new()}}
\item \href{#method-FP-compute}{\code{FP$compute()}}
\item \href{#method-FP-clone}{\code{FP$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FP-new"></a>}}
\if{latex}{\out{\hypertarget{method-FP-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FP$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
used as basis to define the type of compute the \code{FP} measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FP-compute"></a>}}
\if{latex}{\out{\hypertarget{method-FP-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{FP} achieved by the M.L.
model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FP$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the \code{FP}
measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoked by the
\code{\link{ClassificationOutput}} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if
an error occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
