% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortDefinitionSet.R
\name{checkAndFixCohortDefinitionSetDataTypes}
\alias{checkAndFixCohortDefinitionSetDataTypes}
\title{Check if a cohort definition set is using the proper data types}
\usage{
checkAndFixCohortDefinitionSetDataTypes(
  x,
  fixDataTypes = TRUE,
  emitWarning = FALSE
)
}
\arguments{
\item{x}{The cohortDefinitionSet data.frame to check}

\item{fixDataTypes}{When TRUE, this function will attempt to fix the data types
to match the specification. @seealso [createEmptyCohortDefinitionSet()].}

\item{emitWarning}{When TRUE, this function will emit warning messages when problems are
encountered.}
}
\value{
Returns a list() of the following form:

list(
   dataTypesMatch = TRUE/FALSE,
   x = data.frame()
)

dataTypesMatch == TRUE when the supplied data.frame x matches the cohortDefinitionSet
specification's data types.

If fixDataTypes == TRUE, x will hold the original data from x with the
data types corrected. Otherwise x will hold the original value passed to this
function.
}
\description{
This function checks a data.frame to verify it holds the expected format
for a cohortDefinitionSet's data types and can optionally fix data types
that do not match the specification.
}
