% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDateRange.R
\name{requireInDateRange}
\alias{requireInDateRange}
\title{Require that an index date is within a date range}
\usage{
requireInDateRange(
  cohort,
  dateRange,
  cohortId = NULL,
  indexDate = "cohort_start_date",
  atFirst = FALSE,
  name = tableName(cohort)
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{dateRange}{A date vector with the minimum and maximum dates between
which the index date must have been observed.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{indexDate}{Name of the column in the cohort that contains the date of
interest.}

\item{atFirst}{If FALSE the requirement will be applied to all records, if
TRUE, it will only be required for the first entry of each subject.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
The cohort table with any cohort entries outside of the date range
dropped
}
\description{
\code{requireInDateRange()} filters cohort records, keeping only those for
which the index date is within the specified date range.
}
\examples{
\donttest{
library(CohortConstructor)
if(isTRUE(omock::isMockDatasetDownloaded("GiBleed"))){
cdm <- mockCohortConstructor()

cdm$cohort1 |>
  requireInDateRange(indexDate = "cohort_start_date",
                     dateRange = as.Date(c("2010-01-01", "2019-01-01")))
}
}
}
