% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{chile_election_2021_df}
\alias{chile_election_2021_df}
\title{Chilean 2021 First Round Presidential Election}
\format{
A data frame with 46,606 observations and 21 variables:
\describe{
  \item{REGION}{Administrative region (character)}
  \item{ELECTORAL.DISTRICT}{Electoral district (character)}
  \item{BALLOT.BOX}{Unique identifier for the ballot box (character)}
  \item{C1}{Votes for Candidate 1 (integer)}
  \item{C2}{Votes for Candidate 2 (integer)}
  \item{C3}{Votes for Candidate 3 (integer)}
  \item{C4}{Votes for Candidate 4 (integer)}
  \item{C5}{Votes for Candidate 5 (integer)}
  \item{C6}{Votes for Candidate 6 (integer)}
  \item{C7}{Votes for Candidate 7 (integer)}
  \item{BLANK.VOTES}{Count of blank votes (integer)}
  \item{NULL.VOTES}{Count of null votes (integer)}
  \item{X18.19}{Voters aged 18–19 (integer)}
  \item{X20.29}{Voters aged 20–29 (integer)}
  \item{X30.39}{Voters aged 30–39 (integer)}
  \item{X40.49}{Voters aged 40–49 (integer)}
  \item{X50.59}{Voters aged 50–59 (integer)}
  \item{X60.69}{Voters aged 60–69 (integer)}
  \item{X70.79}{Voters aged 70–79 (integer)}
  \item{X80.}{Voters aged 80 and older (integer)}
  \item{MISMATCH}{Logical indicator of inconsistency in vote reporting (logical)}
}
}
\source{
Data taken from the fastei package version 0.0.0.7.
}
\usage{
data(chile_election_2021_df)
}
\description{
This dataset, chile_election_2021_df, is a data frame containing the results of the first round
of the 2021 Chilean presidential elections. It includes vote counts for seven presidential candidates,
as well as counts for blank and null votes. Each observation corresponds to an individual ballot box,
identified by its unique ID and associated electoral district. Additionally, the dataset includes demographic information on the age distribution of voters for each
ballot box, and a logical indicator for mismatches or inconsistencies in the vote counts.
}
\details{
The dataset name has been kept as chile_election_2021_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChileDataAPI package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified.
}
