% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_pseudo_pop.R
\name{generate_pseudo_pop}
\alias{generate_pseudo_pop}
\title{Generate pseudo population}
\usage{
generate_pseudo_pop(
  .data,
  cw_obj,
  covariate_col_names,
  covar_bl_trs = 0.1,
  covar_bl_trs_type = "maximal",
  covar_bl_method = "absolute"
)
}
\arguments{
\item{.data}{A data.frame of observation data with \code{id} column.}

\item{cw_obj}{An S3 object of counter_weight.}

\item{covariate_col_names}{A list of covariate columns.}

\item{covar_bl_trs}{Covariate balance threshold}

\item{covar_bl_trs_type}{Type of the covariance balance threshold.}

\item{covar_bl_method}{Covariate balance method.}
}
\value{
Returns a pseudo population (gpsm_pspop) object that is generated
or augmented based on the selected causal inference approach (ci_appr). The
object includes the following objects:
\itemize{
\item params
\itemize{
\item ci_appr
\item params
}
\item pseudo_pop
\item adjusted_corr_results
\item original_corr_results
\item best_gps_used_params
\item effect size of generated pseudo population
}
}
\description{
Generates pseudo population data set based on user-defined causal inference
approach. The function uses an adaptive approach to satisfies covariate
balance requirements. The function terminates either by satisfying covariate
balance or completing the requested number of iteration, whichever comes
first.
}
\examples{
\donttest{

set.seed(967)

m_d <- generate_syn_data(sample_size = 200)
m_d$id <- seq_along(1:nrow(m_d))

m_xgboost <- function(nthread = 4,
                      ntrees = 35,
                      shrinkage = 0.3,
                      max_depth = 5,
                      ...) {SuperLearner::SL.xgboost(
                        nthread = nthread,
                        ntrees = ntrees,
                        shrinkage=shrinkage,
                        max_depth=max_depth,
                        ...)}

data_with_gps_1 <- estimate_gps(
  .data = m_d,
  .formula = w ~ I(cf1^2) + cf2 + I(cf3^2) + cf4 + cf5 + cf6,
  sl_lib = c("m_xgboost"),
  gps_density = "normal")

cw_object_matching <- compute_counter_weight(gps_obj = data_with_gps_1,
                                             ci_appr = "matching",
                                             bin_seq = NULL,
                                             nthread = 1,
                                             delta_n = 0.1,
                                             dist_measure = "l1",
                                             scale = 0.5)

pseudo_pop <- generate_pseudo_pop(.data = m_d,
                                  cw_obj = cw_object_matching,
                                  covariate_col_names = c("cf1", "cf2",
                                                          "cf3", "cf4",
                                                          "cf5", "cf6"),
                                  covar_bl_trs = 0.1,
                                  covar_bl_trs_type = "maximal",
                                  covar_bl_method = "absolute")

}
}
