% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_circ_mean_reg.R
\name{ch_circ_mean_reg}
\alias{ch_circ_mean_reg}
\title{Calculates the circular mean, median, and regularity}
\usage{
ch_circ_mean_reg(dataframe)
}
\arguments{
\item{dataframe}{a dataframe of day year of event; can be amax or pot.}
}
\value{
Returns a list of the following statistics
  \item{n}{number of samples}
  \item{mean}{circular mean of array}
  \item{median}{circular median of array}
  \item{rho}{regularity or mean resultant length}
}
\description{
Calculate the circular mean, median, and regularity using a year of 365 days.
 Days of year are converted to degrees
 internally, results are returned as positive days of year
}
\examples{
data(CAN05AA008)
am <- ch_sh_get_amax(CAN05AA008)
m_r <- ch_circ_mean_reg(am)
}
\references{
Pewsey, A., M. Neuhauser, and G. D. Ruxton. 2014. Circular Statistics in R, 
 192 pp., Oxford University Press.
 Whitfield, P. H. 2018. Clustering of seasonal events: A simulation study using 
 circular methods. Communications in Statistics - Simulation and Computation 47(10): 3008-3030.
 Burn, D. H., and P. H. Whitfield. 2021*. Changes in the timing of flood events resulting 
 from climate change.
}
\seealso{
\code{\link{ch_sh_get_amax}}
}
