% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbabilityFunctions.R
\name{qkolmogorov}
\alias{qkolmogorov}
\title{Kolmogorov Distribution Quantile Function}
\usage{
qkolmogorov(p, summands = 500, interval = c(0, 100),
  tol = .Machine$double.eps, ...)
}
\arguments{
\item{p}{Value of the CDF at the quantile}

\item{summands}{Number of summands for infinite sum}

\item{interval, tol, ...}{Arguments to be passed to 
\code{\link[stats]{uniroot}}}
}
\value{
The quantile associated with \code{p}
}
\description{
Quantile function for the Kolmogorov distribution.
}
\details{
This function uses \code{\link[stats]{uniroot}} for finding this quantity,
and many of the the accepted parameters are arguments for that function; see
its documentation for more details.
}
\examples{
CPAT:::qkolmogorov(0.5)
}
