/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jebl.evolution.sequences.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StateClassification {
    public String getName();

    public Set<String> getSetNames();

    public String getSetName(State var1);

    public Set<State> getStateSet(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Default
    implements StateClassification {
        private final String name;
        private final Map<String, Set<State>> stateMap = new HashMap<String, Set<State>>();

        public Default(String name, String[] setNames, State[][] stateSets) {
            this.name = name;
            int i = 0;
            for (String setName : setNames) {
                HashSet<State> stateSet = new HashSet<State>();
                for (State state : stateSets[i]) {
                    stateSet.add(state);
                }
                this.stateMap.put(setName, stateSet);
                ++i;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getSetNames() {
            return this.stateMap.keySet();
        }

        @Override
        public String getSetName(State state) {
            for (String setName : this.getSetNames()) {
                if (!this.getStateSet(setName).contains(state)) continue;
                return setName;
            }
            return null;
        }

        @Override
        public Set<State> getStateSet(String setName) {
            return this.stateMap.get(setName);
        }
    }
}

