/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling.mm;

public abstract class MMAlgorithm {
    public static final double DEFAULT_TOLERANCE = 0.1;
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    private static String format = "%5.3e";
    final int qnQ = 0;
    int iteration;
    private static final boolean DEBUG = true;
    private static final boolean PROGRESS = true;

    public double[] findMode(double[] dArray) throws NotConvergedException {
        return this.findMode(dArray, 0.1, 1000);
    }

    private void copyDifference(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] - dArray3[i];
        }
    }

    public double[] findMode(double[] dArray, double d, int n) throws NotConvergedException {
        System.err.println("Starting findMode with " + d + " " + n);
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = dArray2;
        double[] dArray5 = dArray3;
        System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
        this.iteration = 0;
        do {
            double[] dArray6 = dArray4;
            dArray4 = dArray5;
            dArray5 = dArray6;
            System.err.println("Current: " + this.printArray(dArray4));
            this.mmUpdate(dArray4, dArray5);
            ++this.iteration;
            System.err.println("Finished iteration " + this.iteration);
        } while (this.convergenceCriterion(dArray5, dArray4) > d && this.iteration < n);
        System.err.println("Finished in " + this.iteration + " iterations.");
        if (this.iteration >= n) {
            throw new NotConvergedException();
        }
        System.err.println("Final  : " + this.printArray(dArray5));
        return dArray5;
    }

    protected String printArray(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(format, dArray[0]));
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(", ").append(String.format(format, dArray[i]));
        }
        return stringBuilder.toString();
    }

    protected abstract void mmUpdate(double[] var1, double[] var2);

    private double convergenceCriterion(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        double d2 = Math.sqrt(d);
        System.err.println("Convergence = " + d2);
        return d2;
    }

    class NotConvergedException
    extends Exception {
        NotConvergedException() {
        }
    }
}

