/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import dr.inference.loggers.LogFormatter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class TabDelimitedFormatter
implements LogFormatter {
    protected final PrintWriter printWriter;
    private final boolean outputLabels;
    private final boolean closeFile;

    public TabDelimitedFormatter(PrintWriter printWriter) {
        this.printWriter = printWriter;
        this.outputLabels = true;
        this.closeFile = false;
    }

    public TabDelimitedFormatter(OutputStream outputStream) {
        this.printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        this.outputLabels = true;
        this.closeFile = false;
    }

    public TabDelimitedFormatter(PrintWriter printWriter, boolean bl) {
        this.printWriter = printWriter;
        this.outputLabels = bl;
        this.closeFile = true;
    }

    @Override
    public void startLogging(String string) {
    }

    @Override
    public void logHeading(String string) {
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("[\r\n]")) {
                this.printWriter.println("# " + string2);
            }
        }
        this.printWriter.flush();
    }

    @Override
    public void logLine(String string) {
        this.printWriter.println(string);
        this.printWriter.flush();
    }

    @Override
    public void logLabels(String[] stringArray) {
        if (this.outputLabels) {
            if (stringArray.length > 0) {
                this.printWriter.print(stringArray[0]);
            }
            for (int i = 1; i < stringArray.length; ++i) {
                this.printWriter.print('\t');
                this.printWriter.print(stringArray[i]);
            }
            this.printWriter.println();
            this.printWriter.flush();
        }
    }

    @Override
    public void logValues(String[] stringArray) {
        if (stringArray.length > 0) {
            this.printWriter.print(stringArray[0]);
        }
        for (int i = 1; i < stringArray.length; ++i) {
            this.printWriter.print('\t');
            this.printWriter.print(stringArray[i]);
        }
        this.printWriter.println();
        this.printWriter.flush();
    }

    @Override
    public void stopLogging() {
        this.printWriter.flush();
        if (this.closeFile) {
            this.printWriter.close();
        }
    }
}

