/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.model.PriorPreconditioningProvider;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;
import java.util.List;

public class CompoundPriorPreconditioner
implements PriorPreconditioningProvider,
Reportable {
    private final int smallDim;
    private final int totalDim;
    private List<PriorPreconditioningProvider> priorPreconditionerList;
    private int[] iMap;
    private int[] jMap;

    public CompoundPriorPreconditioner(List<PriorPreconditioningProvider> list) {
        this.smallDim = list.get(0).getDimension();
        this.priorPreconditionerList = list;
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n += list.get(i).getDimension();
        }
        this.totalDim = n;
        int[] nArray = new int[this.totalDim];
        int[] nArray2 = new int[this.totalDim];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n3 = 0;
            while (n3 < list.get(i).getDimension()) {
                nArray[n2] = i;
                nArray2[n2] = n3++;
                ++n2;
            }
        }
        this.iMap = nArray;
        this.jMap = nArray2;
    }

    @Override
    public double getStandardDeviation(int n) {
        int n2 = this.iMap[n];
        int n3 = this.jMap[n];
        return this.priorPreconditionerList.get(n2).getStandardDeviation(n3);
    }

    @Override
    public int getDimension() {
        return this.totalDim;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder("compoundPriorPreconditioner Report\n\n");
        stringBuilder.append("totalDim: " + this.totalDim + "\n\n");
        stringBuilder.append("priorPreconditionerList size: " + this.priorPreconditionerList.size() + "\n\n");
        int n = 0;
        for (int i = 0; i < this.priorPreconditionerList.size(); ++i) {
            n += this.priorPreconditionerList.get(i).getDimension();
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getStandardDeviation(i);
        }
        stringBuilder.append("Prior SDs: ");
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

