/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.tree.SimpleNode;
import dr.evolution.util.Date;
import dr.evolution.util.Taxon;
import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class SimpleNodeParser
extends AbstractXMLObjectParser {
    public static final String NODE = "node";
    public static final String HEIGHT = "height";
    public static final String RATE = "rate";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("height", true, "the age of the node"), AttributeRule.newDoubleRule("rate", true, "the relative rate of evolution at this node - default is 1.0"), new XORRule(new ElementRule(Taxon.class, "The taxon of this leaf node"), new ElementRule(SimpleNode.class, "The children of this internal node", 2, 2))};

    @Override
    public String getParserName() {
        return NODE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        SimpleNode simpleNode = new SimpleNode();
        Taxon taxon = null;
        if (xMLObject.hasAttribute(HEIGHT)) {
            simpleNode.setHeight(xMLObject.getDoubleAttribute(HEIGHT));
        }
        if (xMLObject.hasAttribute(RATE)) {
            simpleNode.setRate(xMLObject.getDoubleAttribute(RATE));
        }
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Object object;
            Object object2;
            Object object3 = xMLObject.getChild(i);
            if (object3 instanceof SimpleNode) {
                simpleNode.addChild((SimpleNode)object3);
                continue;
            }
            if (object3 instanceof Taxon) {
                taxon = (Taxon)object3;
                continue;
            }
            if (object3 instanceof Date) {
                simpleNode.setAttribute("date", object3);
                continue;
            }
            if (object3 instanceof Attribute) {
                object2 = (Attribute[])object3;
                String string = object2.getAttributeName();
                object = object2.getAttributeValue();
                simpleNode.setAttribute(string, object);
                continue;
            }
            if (object3 instanceof Attribute[]) {
                object2 = (Attribute[])object3;
                for (int j = 0; j < ((Attribute[])object2).length; ++j) {
                    object = object2[j].getAttributeName();
                    Object t = object2[j].getAttributeValue();
                    simpleNode.setAttribute((String)object, t);
                }
                continue;
            }
            if (object3 instanceof XMLObject) {
                object2 = (XMLObject)object3;
                if (((XMLObject)object2).getName().equals("att")) {
                    simpleNode.setAttribute(((XMLObject)object2).getStringAttribute("name"), ((XMLObject)object2).getAttribute("value"));
                    continue;
                }
                throw new XMLParseException("Unrecognized element" + ((XMLObject)object2).getName() + " found in node element!");
            }
            throw new XMLParseException("Unrecognized element found in node element!");
        }
        if (taxon != null) {
            simpleNode.setTaxon(taxon);
        }
        return simpleNode;
    }

    @Override
    public String getParserDescription() {
        return "This element represents a node in a tree.";
    }

    @Override
    public Class getReturnType() {
        return SimpleNode.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

