/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.nucleotide;

import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.ParameterReplaceableSubstitutionModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.math.matrixAlgebra.Vector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HKY
extends BaseSubstitutionModel
implements Citable,
ParameterReplaceableSubstitutionModel,
DifferentiableSubstitutionModel {
    private Parameter kappaParameter = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("M", "Hasegawa"), new Author("H", "Kishino"), new Author("T", "Yano")}, "Dating the human-ape splitting by a molecular clock of mitochondrial DNA", 1985, "Journal of Molecular Evolution", 22, 160, 174, Citation.Status.PUBLISHED);

    public HKY(double d, FrequencyModel frequencyModel) {
        this(new Parameter.Default(d), frequencyModel);
    }

    public HKY(Parameter parameter, FrequencyModel frequencyModel) {
        super("HKY", Nucleotides.INSTANCE, frequencyModel);
        this.kappaParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        Statistic.Abstract abstract_ = new Statistic.Abstract(){

            @Override
            public String getStatisticName() {
                return "tsTv";
            }

            @Override
            public int getDimension() {
                return 1;
            }

            @Override
            public double getStatisticValue(int n) {
                return HKY.this.getTsTv();
            }
        };
        this.addStatistic(abstract_);
    }

    public void setKappa(double d) {
        this.kappaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public final double getKappa() {
        return this.kappaParameter.getParameterValue(0);
    }

    private double getTsTv() {
        double d = this.freqModel.getFrequency(0);
        double d2 = this.freqModel.getFrequency(1);
        double d3 = this.freqModel.getFrequency(2);
        double d4 = this.freqModel.getFrequency(3);
        double d5 = d + d3;
        double d6 = d2 + d4;
        return this.getKappa() * (d * d3 + d2 * d4) / (d5 * d6);
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        double d = this.kappaParameter.getParameterValue(0);
        dArray[0] = 1.0;
        dArray[1] = d;
        dArray[2] = 1.0;
        dArray[3] = 1.0;
        dArray[4] = d;
        dArray[5] = 1.0;
    }

    @Override
    public synchronized EigenDecomposition getEigenDecomposition() {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        if (this.eigenDecomposition == null) {
            dArray3 = new double[this.stateCount * this.stateCount];
            dArray2 = new double[this.stateCount * this.stateCount];
            dArray = new double[this.stateCount];
            this.eigenDecomposition = new EigenDecomposition(dArray3, dArray2, dArray);
            dArray2[2 * this.stateCount + 1] = 1.0;
            dArray2[2 * this.stateCount + 3] = -1.0;
            dArray2[3 * this.stateCount + 0] = 1.0;
            dArray2[3 * this.stateCount + 2] = -1.0;
            dArray3[0 * this.stateCount + 0] = 1.0;
            dArray3[1 * this.stateCount + 0] = 1.0;
            dArray3[2 * this.stateCount + 0] = 1.0;
            dArray3[3 * this.stateCount + 0] = 1.0;
        }
        if (this.updateMatrix) {
            dArray3 = this.eigenDecomposition.getEigenVectors();
            dArray2 = this.eigenDecomposition.getInverseEigenVectors();
            dArray = this.freqModel.getFrequencies();
            double d = dArray[0] + dArray[2];
            double d2 = dArray[1] + dArray[3];
            dArray2[0 * this.stateCount + 0] = dArray[0];
            dArray2[0 * this.stateCount + 1] = dArray[1];
            dArray2[0 * this.stateCount + 2] = dArray[2];
            dArray2[0 * this.stateCount + 3] = dArray[3];
            dArray2[1 * this.stateCount + 0] = dArray[0] * d2;
            dArray2[1 * this.stateCount + 1] = -dArray[1] * d;
            dArray2[1 * this.stateCount + 2] = dArray[2] * d2;
            dArray2[1 * this.stateCount + 3] = -dArray[3] * d;
            dArray3[0 * this.stateCount + 1] = 1.0 / d;
            dArray3[1 * this.stateCount + 1] = -1.0 / d2;
            dArray3[2 * this.stateCount + 1] = 1.0 / d;
            dArray3[3 * this.stateCount + 1] = -1.0 / d2;
            dArray3[1 * this.stateCount + 2] = dArray[3] / d2;
            dArray3[3 * this.stateCount + 2] = -dArray[1] / d2;
            dArray3[0 * this.stateCount + 3] = dArray[2] / d;
            dArray3[2 * this.stateCount + 3] = -dArray[0] / d;
            double[] dArray4 = this.eigenDecomposition.getEigenValues();
            double d3 = this.getKappa();
            double d4 = -1.0 / (2.0 * (d * d2 + d3 * (dArray[0] * dArray[2] + dArray[1] * dArray[3])));
            double d5 = 1.0 + d * (d3 - 1.0);
            double d6 = 1.0 + d2 * (d3 - 1.0);
            dArray4[1] = d4;
            dArray4[2] = d4 * d6;
            dArray4[3] = d4 * d5;
            this.updateMatrix = false;
        }
        return this.eigenDecomposition;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "HKY nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    public static void main(String[] stringArray) {
        double d = 1.0;
        double[] dArray = new double[]{0.25, 0.25, 0.25, 0.25};
        double d2 = 0.1;
        FrequencyModel frequencyModel = new FrequencyModel((DataType)Nucleotides.INSTANCE, dArray);
        HKY hKY = new HKY(d, frequencyModel);
        EigenDecomposition eigenDecomposition = hKY.getEigenDecomposition();
        Vector vector = new Vector(eigenDecomposition.getEigenValues());
        System.out.println("Eval = " + vector);
        double[] dArray2 = new double[16];
        hKY.getTransitionProbabilities(d2, dArray2);
        System.out.println("new probs = " + new Vector(dArray2));
        dr.oldevomodel.substmodel.FrequencyModel frequencyModel2 = new dr.oldevomodel.substmodel.FrequencyModel((DataType)Nucleotides.INSTANCE, dArray);
        dr.oldevomodel.substmodel.HKY hKY2 = new dr.oldevomodel.substmodel.HKY(d, frequencyModel2);
        hKY2.setKappa(d);
        hKY2.getTransitionProbabilities(d2, dArray2);
        System.out.println("old probs = " + new Vector(dArray2));
    }

    @Override
    public HKY factory(List<Parameter> list, List<Parameter> list2) {
        Parameter parameter = this.kappaParameter;
        FrequencyModel frequencyModel = this.freqModel;
        assert (list.size() == list2.size());
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter2 = list.get(i);
            Parameter parameter3 = list2.get(i);
            if (parameter2 == this.kappaParameter) {
                parameter = parameter3;
                continue;
            }
            if (parameter2 == this.freqModel.getFrequencyParameter()) {
                frequencyModel = new FrequencyModel(this.freqModel.getDataType(), parameter3);
                continue;
            }
            throw new RuntimeException("Parameter not found in HKY SubstitutionModel.");
        }
        return new HKY(parameter, frequencyModel);
    }

    @Override
    public void setupDifferentialRates(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[] dArray, double d) {
        double[] dArray2 = new double[this.rateCount];
        this.setupRelativeRates(dArray2);
        wrtParameter.setupDifferentialRates(dArray, dArray2, d);
    }

    @Override
    public void setupDifferentialFrequency(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[] dArray) {
        wrtParameter.setupDifferentialFrequencies(dArray, this.getFrequencyModel().getFrequencies());
    }

    @Override
    public double getWeightedNormalizationGradient(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[][] dArray, double[] dArray2) {
        double[] dArray3 = this.getFrequencyModel().getFrequencies();
        double[] dArray4 = new double[this.stateCount * this.stateCount];
        this.getInfinitesimalMatrix(dArray4);
        double[] dArray5 = new double[this.stateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            dArray5[i] = dArray4[i * this.stateCount + i];
        }
        double[] dArray6 = new double[this.stateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            dArray6[i] = dArray[i][i];
        }
        return ((WrtHKYModelParameter)wrtParameter).getWeightedNormalizationGradient(dArray6, dArray5, dArray2, dArray3);
    }

    @Override
    public WrappedMatrix getInfinitesimalDifferentialMatrix(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter) {
        return DifferentiableSubstitutionModelUtil.getInfinitesimalDifferentialMatrix(wrtParameter, this);
    }

    @Override
    public DifferentialMassProvider.DifferentialWrapper.WrtParameter factory(Parameter parameter, int n) {
        WrtHKYModelParameter wrtHKYModelParameter;
        block4: {
            block5: {
                block3: {
                    if (parameter != this.kappaParameter) break block3;
                    wrtHKYModelParameter = WrtHKYModelParameter.KAPPA;
                    break block4;
                }
                if (parameter != this.freqModel.getFrequencyParameter()) break block5;
                switch (n) {
                    case 0: {
                        wrtHKYModelParameter = WrtHKYModelParameter.FREQ_A;
                        break block4;
                    }
                    default: {
                        throw new RuntimeException("Not yet implemented!");
                    }
                }
            }
            throw new RuntimeException("Not yet implemented!");
        }
        return wrtHKYModelParameter;
    }

    static enum WrtHKYModelParameter implements DifferentialMassProvider.DifferentialWrapper.WrtParameter
    {
        KAPPA{

            @Override
            double getWeightedNormalizationGradient(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
                return this.getInnerProduct(dArray, dArray4);
            }

            @Override
            public double getRate(int n) {
                switch (n) {
                    case 0: {
                        return 0.0;
                    }
                    case 1: {
                        return 1.0;
                    }
                }
                throw new IllegalArgumentException("Invalid switch case");
            }

            @Override
            public double getNormalizationDifferential() {
                return 1.0;
            }

            @Override
            public void setupDifferentialFrequencies(double[] dArray, double[] dArray2) {
                System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
            }

            @Override
            public void setupDifferentialRates(double[] dArray, double[] dArray2, double d) {
                byte[] byArray = new byte[dArray2.length];
                Arrays.fill(byArray, (byte)0);
                byArray[4] = 1;
                byArray[1] = 1;
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray[i] = this.getRate(byArray[i]) / d;
                }
            }
        }
        ,
        FREQ_A{

            @Override
            double getWeightedNormalizationGradient(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
                return this.getInnerProduct(dArray, dArray4) + this.getInnerProduct(dArray2, dArray3);
            }

            @Override
            public double getRate(int n) {
                return 0.0;
            }

            @Override
            public double getNormalizationDifferential() {
                return 1.0;
            }

            @Override
            public void setupDifferentialFrequencies(double[] dArray, double[] dArray2) {
                Arrays.fill(dArray, 0.0);
                dArray[0] = 1.0;
            }

            @Override
            public void setupDifferentialRates(double[] dArray, double[] dArray2, double d) {
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray[i] = dArray2[i] / d;
                }
            }
        };


        abstract double getWeightedNormalizationGradient(double[] var1, double[] var2, double[] var3, double[] var4);

        public double getInnerProduct(double[] dArray, double[] dArray2) {
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d -= dArray[i] * dArray2[i];
            }
            return d;
        }
    }
}

