/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.continuous.MissingInjection;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.List;

public class MissingInjectionLogger
implements Loggable,
Reportable {
    private static final String MISSING_INJECTION_LOGGER = "injectedMissingTraitsLogger";
    private static final String ADJUSTMENT = "adjustment";
    private final TreeTrait traitProvider;
    private final List<MissingInjection.TaxonInformation> taxonInformation;
    private final Tree tree;
    private final Adjustment adjustment;
    private LogColumn[] logColumns = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MissingInjection.class), new ElementRule(TreeDataLikelihood.class), AttributeRule.newStringRule("adjustment", true)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MissingInjection missingInjection = (MissingInjection)xMLObject.getChild(MissingInjection.class);
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            Tree tree = treeDataLikelihood.getTree();
            String string = missingInjection.getTraitName();
            TreeTrait treeTrait = treeDataLikelihood.getTreeTrait(string);
            if (treeTrait == null) {
                throw new XMLParseException("Unable to find trait '" + string + "'");
            }
            Adjustment adjustment = Adjustment.parse(xMLObject.getAttribute(MissingInjectionLogger.ADJUSTMENT, Adjustment.DIFFERENCE.getName()));
            return new MissingInjectionLogger(missingInjection, treeTrait, tree, adjustment);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return MissingInjectionLogger.class;
        }

        @Override
        public String getParserName() {
            return MissingInjectionLogger.MISSING_INJECTION_LOGGER;
        }
    };

    private MissingInjectionLogger(MissingInjection missingInjection, TreeTrait treeTrait, Tree tree, Adjustment adjustment) {
        this.taxonInformation = missingInjection.getTaxonInformation();
        this.traitProvider = treeTrait;
        this.tree = tree;
        this.adjustment = adjustment;
    }

    @Override
    public LogColumn[] getColumns() {
        if (this.logColumns == null) {
            this.logColumns = this.createLogColumns();
        }
        return this.logColumns;
    }

    private LogColumn[] createLogColumns() {
        int n = this.getNumberOfMissingValues();
        LogColumn[] logColumnArray = new LogColumn[n];
        int n2 = 0;
        for (final MissingInjection.TaxonInformation taxonInformation : this.taxonInformation) {
            for (final MissingInjection.InjectedMissingValue injectedMissingValue : taxonInformation.injectedMissingValues) {
                logColumnArray[n2] = new NumberColumn(MissingInjectionLogger.getColumnName(taxonInformation, injectedMissingValue)){

                    @Override
                    public double getDoubleValue() {
                        return MissingInjectionLogger.this.adjustment.adjustedValue(MissingInjectionLogger.this.getTraitValue(taxonInformation.index, injectedMissingValue.index), injectedMissingValue.originalValue);
                    }
                };
                ++n2;
            }
        }
        return logColumnArray;
    }

    private double getTraitValue(int n, int n2) {
        double[] dArray = (double[])this.traitProvider.getTrait(this.tree, this.tree.getExternalNode(n));
        return dArray[n2];
    }

    private static String getColumnName(MissingInjection.TaxonInformation taxonInformation, MissingInjection.InjectedMissingValue injectedMissingValue) {
        return taxonInformation.taxon.getId() + "." + (injectedMissingValue.index + 1);
    }

    private int getNumberOfMissingValues() {
        int n = 0;
        for (MissingInjection.TaxonInformation taxonInformation : this.taxonInformation) {
            n += taxonInformation.injectedMissingValues.size();
        }
        return n;
    }

    @Override
    public String getReport() {
        LogColumn[] logColumnArray = this.getColumns();
        StringBuilder stringBuilder = new StringBuilder();
        for (LogColumn logColumn : logColumnArray) {
            stringBuilder.append(logColumn.getFormatted()).append("\t");
        }
        return stringBuilder.toString();
    }

    public static enum Adjustment {
        DIFFERENCE("difference"){

            @Override
            double adjustedValue(double d, double d2) {
                return d - d2;
            }
        }
        ,
        ORIGINAL("original"){

            @Override
            double adjustedValue(double d, double d2) {
                return d2;
            }
        }
        ,
        RAW("raw"){

            @Override
            double adjustedValue(double d, double d2) {
                return d;
            }
        };

        private String name;

        private Adjustment(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static Adjustment parse(String string) {
            string = string.toLowerCase();
            for (Adjustment adjustment : Adjustment.values()) {
                if (string.compareTo(adjustment.getName()) != 0) continue;
                return adjustment;
            }
            throw new IllegalArgumentException("Unknown adjustment type");
        }

        abstract double adjustedValue(double var1, double var3);
    }
}

