/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.util.Units;
import dr.evomodel.coalescent.PopulationSizeFunction;
import dr.evomodel.coalescent.PopulationSizeModel;
import dr.evomodelxml.coalescent.demographicmodel.ExponentialGrowthModelParser;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class LogisticPopulationSizeModel
extends PopulationSizeModel
implements Citable {
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);
    private final Parameter rateParameter;
    private final Parameter shapeParameter;

    public LogisticPopulationSizeModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        this(ExponentialGrowthModelParser.EXPONENTIAL_GROWTH_MODEL, parameter, parameter2, parameter3, type);
    }

    public LogisticPopulationSizeModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Units.Type type) {
        super(string, parameter, type);
        this.rateParameter = parameter2;
        this.addVariable(parameter2);
        this.shapeParameter = parameter3;
        this.addVariable(parameter3);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public double getGrowthRate() {
        return this.rateParameter.getParameterValue(0);
    }

    public double getShape() {
        return this.shapeParameter.getParameterValue(0);
    }

    @Override
    public PopulationSizeFunction getPopulationSizeFunction() {
        return new PopulationSizeFunction(){

            @Override
            public double getLogDemographic(double d) {
                throw new UnsupportedOperationException("not implemented yet");
            }

            @Override
            public double getIntegral(double d, double d2) {
                throw new UnsupportedOperationException("not implemented yet");
            }

            @Override
            public Units.Type getUnits() {
                return LogisticPopulationSizeModel.this.getUnits();
            }

            @Override
            public void setUnits(Units.Type type) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Logistic Growth Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

