% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsDist}
\alias{nsDist}
\title{Calculate coordinate-specific distance matrices}
\usage{
nsDist(coords, scale_factor = NULL, isotropic = FALSE)
}
\arguments{
\item{coords}{N x 2 matrix; contains the x-y coordinates of stations}

\item{scale_factor}{Scalar; optional argument for re-scaling the distances.}

\item{isotropic}{Logical; indicates whether distances should be calculated
separately for each coordinate dimension (FALSE) or simultaneously for all
coordinate dimensions (TRUE). \code{isotropic = TRUE} can only be used for
two-dimensional coordinate systems.}
}
\value{
A list of distances matrices, with the following components:
\item{dist1_sq}{N x N matrix; contains values of pairwise squared distances
in the x-coordinate.}
\item{dist2_sq}{N x N matrix; contains values of pairwise squared distances
in the y-coordinate.}
\item{dist12}{N x N matrix; contains values of pairwise signed cross-
distances between the x- and y-coordinates.}
\item{scale_factor}{Value of the scale factor used to rescale distances.}
}
\description{
\code{nsDist} calculates x, y, and x-y distances for use in the 
nonstationary correlation calculation. The sign of the cross-distance
is important. The function contains an optional argument for re-scaling
the distances such that the coordinates lie in a square.
}
\examples{
# Generate some coordinates
coords <- cbind(runif(100),runif(100))
# Calculate distances
dist_list <- nsDist(coords)
# Use nsDist to calculate Euclidean distances
dist_Euclidean <- sqrt(nsDist(coords, isotropic = TRUE)$dist1_sq)

}
