% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_spec_coveff.R
\name{build_spec_coveff}
\alias{build_spec_coveff}
\title{Build specifications for covariate effect simulation/visualization}
\usage{
build_spec_coveff(
  ermod,
  data = NULL,
  qi_width_cov = 0.9,
  n_sigfig = 3,
  use_seps = TRUE,
  drop_trailing_dec_mark = TRUE
)
}
\arguments{
\item{ermod}{an object of class \code{ermod}}

\item{data}{an optional data frame to derive the covariate values for
forest plots. If NULL (default), the data used to fit the model is used.}

\item{qi_width_cov}{the width of the quantile interval for continuous
covariates in the forest plot. Default is 0.9 (i.e. visualize effect of
covariate effect at their 5th and 95th percentile values).}

\item{n_sigfig}{Number of significant figures to form value_label of
continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{use_seps}{Whether to use separators for thousands in printing numbers.
See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{drop_trailing_dec_mark}{Whether to drop the trailing decimal mark
(".") in value_label of continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}}
for details.}
}
\value{
\code{spec_coveff} (return object) is a data frame for the specification
of the covariate effects to be visualized. This is internally generated by
\code{\link[=build_spec_coveff]{build_spec_coveff()}} if you run \code{\link[=sim_coveff]{sim_coveff()}} or \code{\link[=plot_coveff]{plot_coveff()}}
directly. Alternatively, you can develop your own or modify the one
generated by \code{\link[=build_spec_coveff]{build_spec_coveff()}} and supply it to \code{\link[=sim_coveff]{sim_coveff()}} or
\code{\link[=plot_coveff]{plot_coveff()}}. The data frame should have the following columns (but
it's probably easier to try \code{\link[=build_spec_coveff]{build_spec_coveff()}} and see the structure):
\itemize{
\item \code{var_order}: The order of the covariate in the forest plot. The exposure
variable is always the first one and the covariates are ordered by the
order they are supplied in the \code{var_cov} argument of the \verb{dev_ermod_*}
function. If you used a model from \code{\link[=dev_ermod_bin_cov_sel]{dev_ermod_bin_cov_sel()}}, then the
order is determined by the variable selection process.
\item \code{var_name}: The name of the variable.
\item \code{var_label}: The label of the variable to be used for plot.
This is the same as \code{var_name} by default.
\item \code{value_order}: The order of the value of the variable to be evaluated.
\item \code{value_annot}: The annotation of the value of the variable to be
evaluated. This appears on the right hand side of the forest plot.
\item \code{value_label}: The label of the value of the variable to be evaluated.
\item \code{value_cont}: The value for continuous variables.
\item \code{value_cat}: The value for categorical variables.
\item \code{is_ref_value}: Whether the value is the reference value.
\item \code{show_ref_value}: Whether to show the reference value in the plot and
table. This is TRUE by default for is_ref_value == TRUE, otherwise NA
(and ignored).
\item \code{is_covariate}: Whether the variable is a covariate (TRUE) or exposure
variable (FALSE).
}
}
\description{
Build specifications for covariate effect simulation/visualization
}
\examples{
\dontshow{if (BayesERtools:::.if_run_ex_coveff()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = c("BHBA1C_5", "RACE"),
)

spec_coveff <- build_spec_coveff(ermod_bin)
plot_coveff(ermod_bin, spec_coveff = spec_coveff)
}
\dontshow{\}) # examplesIf}
}
