% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_svc_principal.R
\docType{class}
\name{az_service_principal}
\alias{az_service_principal}
\title{Service principal in Azure Active Directory}
\format{
An R6 object of class \code{az_service_principal}, inheriting from \code{az_object}.
}
\description{
Class representing an AAD service principal.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this service principal.
\item \code{type}: always "service principal" for a service principal object.
\item \code{properties}: The service principal properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new service principal object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete a service principal. By default, ask for confirmation first.
\item \code{update(...)}: Update the service principal information in Azure Active Directory.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the service principal.
\item \code{sync_fields()}: Synchronise the R object with the service principal data in Azure Active Directory.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{create_service_principal} and \code{get_service_principal} methods of the \link{ms_graph} and \link{az_app} classes. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to create the actual service principal.
}

\seealso{
\link{ms_graph}, \link{az_app}, \link{az_object}

\href{https://learn.microsoft.com/en-us/graph/overview}{Azure Microsoft Graph overview},
\href{https://learn.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
