% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.PartialDependence.HeatMap}
\alias{Plot.PartialDependence.HeatMap}
\title{Plot.PartialDependence.HeatMap}
\usage{
Plot.PartialDependence.HeatMap(
  dt = NULL,
  XVar = NULL,
  YVar = NULL,
  ZVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  ZVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumberBins = 21,
  AggMethod = "mean",
  Height = NULL,
  Width = NULL,
  Title = "Partial Dependence Heatmap",
  ShowLabels = FALSE,
  MouseScroll = TRUE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  EchartsLabels = FALSE,
  TimeLine = TRUE,
  TextColor = "white",
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{XVar}{X-Axis variable name}

\item{YVar}{Y-Axis variable name}

\item{ZVar}{character}

\item{GroupVar}{Character variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{ZVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{NumberBins}{numeric}

\item{AggMethod}{character}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{character}

\item{ShowLabels}{character}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{EchartsLabels}{character}

\item{TimeLine}{logical}

\item{TextColor}{hex character}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
This function automatically builds partial dependence calibration plots
}
\seealso{
Other Model Evaluation: 
\code{\link{Plot.BinaryMetrics}()},
\code{\link{Plot.Calibration.Box}()},
\code{\link{Plot.Calibration.Line}()},
\code{\link{Plot.ConfusionMatrix}()},
\code{\link{Plot.Gains}()},
\code{\link{Plot.Lift}()},
\code{\link{Plot.PartialDependence.Box}()},
\code{\link{Plot.PartialDependence.Line}()},
\code{\link{Plot.ROC}()},
\code{\link{Plot.Residuals.Histogram}()},
\code{\link{Plot.Residuals.Scatter}()},
\code{\link{Plot.ShapImportance}()},
\code{\link{Plot.VariableImportance}()}
}
\author{
Adrian Antico
}
\concept{Model Evaluation}
