% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{generate_age_pyramid_plot}
\alias{generate_age_pyramid_plot}
\title{Generate and Save Age Pyramid Plot}
\usage{
generate_age_pyramid_plot(
  dataset,
  country_code,
  output_dir,
  line_color = "#67000d",
  fill_high = "#fee0d2",
  fill_low = "#a50f15",
  break_axis_by = 10,
  caption = paste0("Note: Total population includes ",
    "ages 99+, pyramid shows ages 0-99")
)
}
\arguments{
\item{dataset}{A list containing two data frames:
- prop_df: Population proportions data frame
- pop_df: Population counts data frame
Each with columns for `country`, `region`, `district`, and columns ending
with "mean"}

\item{country_code}{A string representing the country code (e.g., "ken").}

\item{output_dir}{A string specifying the directory where plots should be saved.}

\item{line_color}{A string specifying the color of the plot's lines. Default
is `"#67000d"`.}

\item{fill_high}{A string specifying the fill color for high values. Default
is `"#fee0d2"`.}

\item{fill_low}{A string specifying the fill color for low values. Default
is `"#a50f15"`}

\item{break_axis_by}{break axis to show less cluttered age groups. Default
is 10}

\item{caption}{A string specifying the caption text. Default is "Note: Total
population includes ages 99+, pyramid shows ages 0-99"}
}
\value{
A list containing both proportion and count plots.
}
\description{
This function processes an input dataset to compute age distribution,
generates age pyramid plots by region showing both proportions and counts,
and saves the plots to a specified directory.
}
\examples{
\donttest{
set.seed(123)
prop_df <- data.frame(
 country = rep("COD", 10),
 region = rep("RegionA", 10),
 district = paste("District", 1:10),
 popsize = runif(10, 2340, 28761),
 `0-4_mean` = runif(10, 0.1, 0.5),
 `5-9_mean` = runif(10, 0.05, 0.4),
 `10-14_mean` = runif(10, 0.03, 0.3)
)

pop_df <- data.frame(
 country = rep("COD", 10),
 region = rep("RegionA", 10),
 district = paste("District", 1:10),
 popsize = runif(10, 2340, 28761),
 `0-4_mean` = runif(10, 1000, 5000),
 `5-9_mean` = runif(10, 800, 4500),
 `10-14_mean` = runif(10, 700, 4000)
)

dataset <- list(prop_df = prop_df, pop_df = pop_df)

res <- generate_age_pyramid_plot(
         dataset = dataset,
         country_code = "COD",
         output_dir = file.path(tempdir()))
}

}
