% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{create_project_structure}
\alias{create_project_structure}
\title{Create a Standardized Project Folder Structure}
\usage{
create_project_structure(base_path = here::here())
}
\arguments{
\item{base_path}{A character string specifying the root directory where
the folder structure will be created. Defaults to `here::here()`
to use the current project directory.}
}
\value{
Creates directories under the specified `base_path`. Returns
  invisible `NULL` and prints messages about folder creation status.
}
\description{
This function creates a standardized folder structure for organizing
data, scripts, and outputs within a project directory. It ensures
consistency and reproducibility for data-related workflows.
}
\details{
The function generates the following folder structure:
\preformatted{
# 01_data/
# +-- 1a_survey_data/
# |    +-- processed/
# |    \-- raw/
# +-- 1b_rasters/
# |    +-- urban_extent/
# |    \-- pop_raster/
# +-- 1c_shapefiles/
# 02_scripts/
# 03_outputs/
# +-- 3a_model_outputs/
# +-- 3b_visualizations/
# +-- 3c_table_outputs/
# \-- 3d_compiled_results/
}
}
\examples{
\donttest{
# Create temp directory with normalized path
tf <- file.path(tempdir(), "test_env")
dir.create(tf, recursive = TRUE, showWarnings = FALSE)

#  Initialize with normalized path
cpp_path <- file.path(tf, "02_scripts", "model")
dir.create(cpp_path, recursive = TRUE, showWarnings = FALSE)
cpp_path <- normalizePath(cpp_path, winslash = "/", mustWork = FALSE)

create_project_structure(base_path = tf)
}
}
