% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\docType{data}
\name{vars_ph_p_cna}
\alias{vars_ph_p_cna}
\alias{compute_ph_p_cna_sum}
\title{Compute "Child Nutrition Assessment [Parent]: Sum [Validation: No more than
0 missing or declined]"}
\format{
vars_ph_p_cna is a character vector of all column names
used to compute summary scores of \code{ph_p_cna}.
}
\usage{
vars_ph_p_cna

compute_ph_p_cna_sum(
  data,
  name = "ph_p_cna_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score. \code{NULL} means no limit.}

\item{exclude}{character, Values to be excluded from the summary score.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_p_cna_sum}
Child Nutrition Assessment [Parent]: Sum [Validation: No more than 0
missing or declined]
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_p_cna_001}
\item \code{ph_p_cna_002}
\item \code{ph_p_cna_003}
\item \code{ph_p_cna_004}
\item \code{ph_p_cna_005}
\item \code{ph_p_cna_006}
\item \code{ph_p_cna_007}
\item \code{ph_p_cna_008}
\item \code{ph_p_cna_009}
\item \code{ph_p_cna_010}
\item \code{ph_p_cna_011}
\item \code{ph_p_cna_012}
\item \code{ph_p_cna_013}
\item \code{ph_p_cna_014}
}
\item \emph{Excluded values:}
\itemize{
\item 999
\item 777
}
\item \emph{Validation criterion:} maximally 0 of 14 items missing
}
}
\examples{
\dontrun{
compute_ph_p_cna_sum(data) |>
  select(
    all_of(c("ph_p_cna_sum", vars_ph_p_cna))
  )
}
}
\keyword{datasets}
