% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_cbcl__strs_sum}
\alias{compute_mh_p_cbcl__strs_sum}
\title{Compute "Child Behavior Checklist [Parent] (Stress): Sum"}
\usage{
compute_mh_p_cbcl__strs_sum(
  data,
  name = "mh_p_cbcl__strs_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_cbcl__strs_sum}
Child Behavior Checklist [Parent] (Stress): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_cbcl__aggr__opp_001}
\item \code{mh_p_cbcl__attn__adhd_002}
\item \code{mh_p_cbcl__tho_001}
\item \code{mh_p_cbcl__wthdep__dep_002}
\item \code{mh_p_cbcl__soc__anx_001}
\item \code{mh_p_cbcl__wthdep_005}
\item \code{mh_p_cbcl__anxdep__anx_003}
\item \code{mh_p_cbcl__soc_004}
\item \code{mh_p_cbcl__anxdep__anx_004}
\item \code{mh_p_cbcl__som__anx_001}
\item \code{mh_p_cbcl__anxdep__anx_005}
\item \code{mh_p_cbcl__anxdep__dep_003}
\item \code{mh_p_cbcl__wthdep_003}
\item \code{mh_p_cbcl__aggr_004}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 14 items missing
}
}
\examples{
\dontrun{
compute_mh_p_cbcl__strs_sum(data) |>
  select(
    any_of(c("mh_p_cbcl__strs_sum", vars_mh_p_cbcl__strs))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_cbcl__strs_nm]{compute_mh_p_cbcl__strs_nm()}}
}
