% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize-str.R
\name{str_jnormalize}
\alias{str_jnormalize}
\title{Converts characters following the rules of 'neologd'}
\usage{
str_jnormalize(str)
}
\arguments{
\item{str}{Input vector.}
}
\value{
a character
}
\description{
Converts characters following the rules of 'neologd'
}
\details{
Converts the characters into normalized style
basing on rules that is recommended by the Neologism dictionary for MeCab.
}
\examples{
str_jnormalize(
  paste0(
    "    \uff30",
    "\uff32\uff2d\uff2c\u300    \u526f    \u8aad    \u672c      "
  )
)
str_jnormalize(
  paste0(
    "\u5357\u30a2\u30eb\u30d7\u30b9\u306e\u3000\u5929\u7136\u6c34",
    "-\u3000\uff33\uff50\uff41\uff52\uff4b\uff49\uff4e\uff47\u3000",
    "\uff2c\uff45\uff4d\uff4f\uff4e\u3000\u30ec\u30e2\u30f3\u4e00\u7d5e\u308a"
 )
)
}
\seealso{
\url{https://github.com/neologd/mecab-ipadic-neologd/wiki/Regexp.ja}
}
