% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.VPC.both.R
\name{xpose.VPC.both}
\alias{xpose.VPC.both}
\title{Xpose Visual Predictive Check (VPC) for both continuous and Limit of
Quantification data.}
\usage{
xpose.VPC.both(
  vpc.info = "vpc_results.csv",
  vpctab = dir(pattern = "^vpctab")[1],
  object = NULL,
  subset = NULL,
  main = "Default",
  main.sub = NULL,
  inclZeroWRES = FALSE,
  cont.logy = F,
  hline = "default",
  add.args.cont = list(),
  add.args.cat = list(),
  ...
)
}
\arguments{
\item{vpc.info}{Name of PSN file to use.  File will come from \code{VPC}
command in PsN.}

\item{vpctab}{Name of vpctab file produced from PsN.}

\item{object}{Xpose data object.}

\item{subset}{Subset of data to look at.}

\item{main}{Title for plot.}

\item{main.sub}{Used for names above each plot when using multiple plots.
Should be a vector, e.g. \code{c("title 1","title 2")}.}

\item{inclZeroWRES}{Include WRES=0 rows in the computations for these plots?}

\item{cont.logy}{Should the continuous plot y-axis be on the log scale?}

\item{hline}{Horizontal line marking the limits of quantification.  If they
are defined, they must be a vector of values.}

\item{add.args.cont}{Additional arguments to the continuous plot.
\code{\link{xpose.VPC}}.}

\item{add.args.cat}{Additional arguments to the categorical plot.
\code{\link{xpose.VPC.categorical}}.}

\item{\dots}{Additional arguments to both plots.}
}
\description{
Xpose Visual Predictive Check (VPC) for both continuous and Below or Above
Limit of Quantification (BLQ or ALQ) data.
}
\examples{

\dontrun{
library(xpose4)

## move to the directory where results from PsN
## are found
cur.dir <- getwd()
setwd(paste(cur.dir,"/vpc_cont_LLOQ/",sep=""))

xpose.VPC()
xpose.VPC.categorical(censored=T)

xpose.VPC.both()

xpose.VPC.both(subset="DV>1.75")

xpose.VPC.both(add.args.cont=list(ylim=c(0,80)))

xpose.VPC.both(add.args.cont = list(ylim = c(0.01, 80)), xlim = c(0, 
    40), add.args.cat = list(ylim = c(0, 0.4)), cont.logy = T)

xpose.VPC.both(cont.logy=T)
}

}
\seealso{
\code{\link{xpose.VPC}}, \code{\link{xpose.VPC.categorical}}.

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{npc.coverage}()},
\code{\link{randtest.hist}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{read.vpctab}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
Andrew C. Hooker
}
\concept{PsN functions}
\concept{specific functions}
\keyword{methods}
