% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_set.R
\name{focus_xpdb}
\alias{focus_xpdb}
\alias{unfocus_xpdb}
\alias{focused_xpdbs}
\alias{focus_function}
\alias{focus_qapply}
\title{Focus on an xpdb object in an xpose_set}
\usage{
focus_xpdb(xpdb_s, ..., .add = FALSE)

unfocus_xpdb(xpdb_s)

focused_xpdbs(xpdb_s)

focus_function(xpdb_s, fn, ...)

focus_qapply(xpdb_s, fn, ..., .mods = everything())
}
\arguments{
\item{xpdb_s}{<\code{\link{xpose_set}}> An xpose_set object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> One or more xpdb objects to focus on}

\item{.add}{<\code{\link{logical}}> Should the focus be added to the existing focus? (default: \code{FALSE})}

\item{fn}{<\code{function}> to apply to focused \code{xpose_data} objects}

\item{.mods}{<\code{tidyselect}> Model names in set to quick-apply a function. See Details.}
}
\value{
An \code{xpose_set} object with the focused xpdb object(s)
}
\description{
For piping, set is passed, but with S3 method transformations are applied to the focused \code{xpdb} object.
}
\details{
While these functions are used internally, it is recognized that they may have value
in user scripting. It is hoped these are self-explanatory, but the examples should
address common uses.

\emph{Note:} \code{focus_qapply()} (re)focuses as specified in \code{.mods} and then un-focuses all elements
of the set so should only be used in the case where a quick application
suffices. Otherwise, focusing with a sequence of \code{focus_function} calls
(or a monolithic single \code{focus_function} call with a custom function)
should be preferred.
}
\examples{

# Select two xpdb objects to focus on
xpdb_set \%>\% focus_xpdb(mod2,fix1)

# Add a focus
xpdb_set \%>\% focus_xpdb(mod2,fix1) \%>\% focus_xpdb(mod1, .add=TRUE)

# Remove focus
xpdb_set \%>\% focus_xpdb(mod2,fix1) \%>\% focus_xpdb()

# Focus function and tidyselect
pheno_set \%>\%
  focus_xpdb(everything()) \%>\%
  # Add iOFV col and iofv type to all xpdbs in set
  focus_function(backfill_iofv) \%>\%
  # Show 1... can do all like this, too, but no need
  unfocus_xpdb() \%>\%
  select(run6) \%>\%
  {.[[1]]$xpdb} \%>\%
  list_vars()

# Quick-apply version of previous example
pheno_set \%>\%
  focus_qapply(backfill_iofv) \%>\%
  select(run6) \%>\%
  {.[[1]]$xpdb} \%>\%
  list_vars()

}
