% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooling.R
\name{ExponentialAdditiveCooling}
\alias{ExponentialAdditiveCooling}
\title{Exponential additive cooling.}
\usage{
ExponentialAdditiveCooling(k, lF)
}
\arguments{
\item{k}{Number of steps to discount.}

\item{lF}{Local configuration.}
}
\value{
The temperature at time k.
}
\description{
This schedule decreases in proportion to the
             inverse of \code{exp} raised to the 
             power of the temperature cycle in
             \code{lF$Generations()} (= number of generations) fractions 
             between the starting temperature \code{temp0}
             and the final temperature \code{tempN}.
}
\details{
Temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
         \code{lF$Temp0()} is the starting temperature.
         \code{lF$TempN()} is the final temperature.
         \code{lF$Generations()} is the number of generations (time).
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list(Temp0=parm(100), TempN=parm(10), Generations=parm(50))
ExponentialAdditiveCooling(0, lF)
ExponentialAdditiveCooling(2, lF)
}
\references{
The-Crankshaft Publishing (2023)
         A Comparison of Cooling Schedules for Simulated Annealing.
  <https://what-when-how.com/artificial-intelligence/a-comparison-of-cooling-schedules-for-simulated-annealing-artificial-intelligence/>
}
\seealso{
Other Cooling: 
\code{\link{ExponentialMultiplicativeCooling}()},
\code{\link{LogarithmicMultiplicativeCooling}()},
\code{\link{PowerAdditiveCooling}()},
\code{\link{PowerMultiplicativeCooling}()},
\code{\link{TrigonometricAdditiveCooling}()}
}
\concept{Cooling}
