% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{warp_change}
\alias{warp_change}
\title{Detect changes in a date time vector}
\usage{
warp_change(
  x,
  period,
  ...,
  every = 1L,
  origin = NULL,
  last = TRUE,
  endpoint = FALSE
)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date time vector.}

\item{period}{\verb{[character(1)]}

A string defining the period to group by. Valid inputs can be roughly
broken into:
\itemize{
\item \code{"year"}, \code{"quarter"}, \code{"month"}, \code{"week"}, \code{"day"}
\item \code{"hour"}, \code{"minute"}, \code{"second"}, \code{"millisecond"}
\item \code{"yweek"}, \code{"mweek"}
\item \code{"yday"}, \code{"mday"}
}}

\item{...}{\verb{[dots]}

These dots are for future extensions and must be empty.}

\item{every}{\verb{[positive integer(1)]}

The number of periods to group together.

For example, if the period was set to \code{"year"} with an every value of \code{2},
then the years 1970 and 1971 would be placed in the same group.}

\item{origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

The reference date time value. The default when left as \code{NULL} is the
epoch time of \verb{1970-01-01 00:00:00}, \emph{in the time zone of the index}.

This is generally used to define the anchor time to count from, which is
relevant when the every value is \verb{> 1}.}

\item{last}{\verb{[logical(1)]}

If \code{TRUE}, the \emph{last} location \emph{before} a change is returned.
The last location of the input is always returned.

If \code{FALSE}, the \emph{first} location \emph{after} a change is returned.
The first location of the input is always returned.}

\item{endpoint}{\verb{[logical(1)]}

If \code{TRUE} and \code{last = TRUE}, will additionally return the first location
of the input.

If \code{TRUE} and \code{last = FALSE}, will additionally return the last location
of the input.

If \code{FALSE}, does nothing.}
}
\value{
A double vector of locations.
}
\description{
\code{warp_change()} detects changes at the \code{period} level.

If \code{last = TRUE}, it returns locations of the last value before a change,
and the last location in \code{x} is always included. Additionally, if
\code{endpoint = TRUE}, the first location in \code{x} will be included.

If \code{last = FALSE}, it returns locations of the first value after a change,
and the first location in \code{x} is always included. Additionally, if
\code{endpoint = TRUE}, the last location in \code{x} will be included.
}
\examples{
x <- as.Date("2019-01-01") + 0:5
x

# Last location before a change, last location of `x` is always included
warp_change(x, period = "yday", every = 2, last = TRUE)

# Also include first location
warp_change(x, period = "yday", every = 2, last = TRUE, endpoint = TRUE)

# First location after a change, first location of `x` is always included
warp_change(x, period = "yday", every = 2, last = FALSE)

# Also include last location
warp_change(x, period = "yday", every = 2, last = FALSE, endpoint = TRUE)
}
