% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_relation.R
\name{new_relation}
\alias{new_relation}
\alias{new_relation.vegtable}
\alias{new_relation,vegtable-method}
\alias{new_relation<-}
\alias{new_relation<-,vegtable,character,character-method}
\alias{new_relation<-,vegtable,missing,character-method}
\title{Insert a new variable as relation in vegtable object}
\usage{
new_relation(object, ...)

\method{new_relation}{vegtable}(object, relation, levels, ...)

new_relation(object, levels) <- value

\S4method{new_relation}{vegtable,character,character}(object, levels) <- value

\S4method{new_relation}{vegtable,missing,character}(object) <- value
}
\arguments{
\item{object}{A \linkS4class{vegtable} object.}

\item{...}{Further arguments passed among methods.}

\item{relation, value}{A character value indicating the name of the new
relation. The parameter 'value' is used for the replacement method}

\item{levels}{A character vector with the levels for the inserted factor.
This may be missing for variables that already exist in slot \strong{header}.}
}
\value{
A \linkS4class{vegtable} object with the inserted new relation.
}
\description{
Insert a new variable in slot \strong{header} with a respective table at slot
\strong{relations}. The respective variable in header will be set as factor.

Existing categorical variables can also be set as relations. If such
variables are factors, its levels can be preserved (missing argument in
\code{'levels'}) or reset.
}
\examples{
## A brand new variable
new_relation(Kenya_veg, levels = c("forest", "grassland", "cropland")) <- "land_use"

## Set an existing variable as relation
new_relation(Kenya_veg) <- "REMARKS"

}
